package com.thebeastshop.payment.exception;


import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import static com.thebeastshop.payment.enums.PPaymentErrorCodeEnum.PAYMENT_FREQUENT;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-27 18:40
 */
public class PPaymentFrequentException extends PPaymentException {

    private Date startTime;

    private Long duration;

    private Long restDuration;

    private Map<String, Object> map = new HashMap<>();


    public PPaymentFrequentException(Date startTime, Long duration, Long restDuration) {
        super(PAYMENT_FREQUENT, "请在" + time2string(restDuration) + "后尝试支付");
        this.startTime = startTime;
        this.duration = duration;
        this.restDuration = restDuration;
        map.put("startTime", startTime);
        map.put("duration", duration);
        map.put("restDuration", restDuration);
    }


    private static String time2string(long time) {
        if (time < 60) {
            return time + "秒";
        }
        time = time / 60;
        if (time < 60) {
            return time + "分钟";
        }
        time = time / 60;
        if (time < 24) {
            return time + "小时";
        }
        return time + "天";
    }

    public Date getStartTime() {
        return startTime;
    }

    public Long getDuration() {
        return duration;
    }

    public Long getRestDuration() {
        return restDuration;
    }

    @Override
    public Map<String, Object> getErrorData() {
        return map;
    }
}
