/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.member.vo;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.MemberLevelEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MemberVO
extends BaseDO {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Integer oid;
    private String code;
    private Integer memberStatus;
    private Integer memberLevel;
    private Integer startupLevel;
    private String nickName;
    private Integer gender;
    private String phone;
    private String mobile;
    private String email;
    private Integer registerSource;
    private Date registerTime;
    private Date birthday;
    private Long birthdayLong;
    private Date birthdayAddTime;
    private Integer birthdayAddSource;
    private Integer birthdayAddFlag;
    private Long districtId;
    private String address;
    private String zipCode;
    private Integer title;
    private String avatarUrl;
    private String job;
    private Integer constellation;
    private Integer degree;
    private String accountWechat;
    private String accountWeibo;
    private Date lastLoginTime;
    private String mergeTo;
    private String remark;
    private String province;
    private String district;
    private Date lastLevelUpdateTime;
    private BigDecimal lastLevelUpdateConsumption;
    private String verifiedMobile;
    private String mobileCode;
    private Integer birthdayDiscountYear;
    private String downloadSource;
    private String channelCode;
    private String payPasswd;
    private String redenvelopeMobileWechat;
    private String birthdayFlowerYear;
    private String deregisterReason;
    private String utmSource;
    private Integer staffId;
    private Boolean enroll = false;
    private Boolean register = false;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOid() {
        return this.oid;
    }

    public void setOid(Integer oid) {
        this.oid = oid;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getMemberStatus() {
        return this.memberStatus;
    }

    public void setMemberStatus(Integer memberStatus) {
        this.memberStatus = memberStatus;
    }

    public Integer getMemberLevel() {
        return this.memberLevel;
    }

    public void setMemberLevel(Integer memberLevel) {
        this.memberLevel = memberLevel;
    }

    public Integer getStartupLevel() {
        return this.startupLevel;
    }

    public void setStartupLevel(Integer startupLevel) {
        this.startupLevel = startupLevel;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Integer getGender() {
        return this.gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getBirthdayLong() {
        return this.birthdayLong;
    }

    public void setBirthdayLong(Long birthdayLong) {
        this.birthdayLong = birthdayLong;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getRegisterSource() {
        return this.registerSource;
    }

    public void setRegisterSource(Integer registerSource) {
        this.registerSource = registerSource;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public Date getBirthdayAddTime() {
        return this.birthdayAddTime;
    }

    public void setBirthdayAddTime(Date birthdayAddTime) {
        this.birthdayAddTime = birthdayAddTime;
    }

    public Integer getBirthdayAddSource() {
        return this.birthdayAddSource;
    }

    public void setBirthdayAddSource(Integer birthdayAddSource) {
        this.birthdayAddSource = birthdayAddSource;
    }

    public Integer getBirthdayAddFlag() {
        return this.birthdayAddFlag;
    }

    public void setBirthdayAddFlag(Integer birthdayAddFlag) {
        this.birthdayAddFlag = birthdayAddFlag;
    }

    public Long getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public Integer getTitle() {
        return this.title;
    }

    public void setTitle(Integer title) {
        this.title = title;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public Integer getConstellation() {
        return this.constellation;
    }

    public void setConstellation(Integer constellation) {
        this.constellation = constellation;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public void setDegree(Integer degree) {
        this.degree = degree;
    }

    public String getAccountWechat() {
        return this.accountWechat;
    }

    public void setAccountWechat(String accountWechat) {
        this.accountWechat = accountWechat;
    }

    public String getAccountWeibo() {
        return this.accountWeibo;
    }

    public void setAccountWeibo(String accountWeibo) {
        this.accountWeibo = accountWeibo;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getMergeTo() {
        return this.mergeTo;
    }

    public void setMergeTo(String mergeTo) {
        this.mergeTo = mergeTo;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Date getLastLevelUpdateTime() {
        return this.lastLevelUpdateTime;
    }

    public void setLastLevelUpdateTime(Date lastLevelUpdateTime) {
        this.lastLevelUpdateTime = lastLevelUpdateTime;
    }

    public BigDecimal getLastLevelUpdateConsumption() {
        return this.lastLevelUpdateConsumption;
    }

    public void setLastLevelUpdateConsumption(BigDecimal lastLevelUpdateConsumption) {
        this.lastLevelUpdateConsumption = lastLevelUpdateConsumption;
    }

    public String getVerifiedMobile() {
        return this.verifiedMobile;
    }

    public void setVerifiedMobile(String verifiedMobile) {
        this.verifiedMobile = verifiedMobile;
    }

    public String getMobileCode() {
        return this.mobileCode;
    }

    public void setMobileCode(String mobileCode) {
        this.mobileCode = mobileCode;
    }

    public Integer getBirthdayDiscountYear() {
        return this.birthdayDiscountYear;
    }

    public void setBirthdayDiscountYear(Integer birthdayDiscountYear) {
        this.birthdayDiscountYear = birthdayDiscountYear;
    }

    public String getDownloadSource() {
        return this.downloadSource;
    }

    public void setDownloadSource(String downloadSource) {
        this.downloadSource = downloadSource;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getPayPasswd() {
        return this.payPasswd;
    }

    public void setPayPasswd(String payPasswd) {
        this.payPasswd = payPasswd;
    }

    public String getRedenvelopeMobileWechat() {
        return this.redenvelopeMobileWechat;
    }

    public void setRedenvelopeMobileWechat(String redenvelopeMobileWechat) {
        this.redenvelopeMobileWechat = redenvelopeMobileWechat;
    }

    public String getBirthdayFlowerYear() {
        return this.birthdayFlowerYear;
    }

    public void setBirthdayFlowerYear(String birthdayFlowerYear) {
        this.birthdayFlowerYear = birthdayFlowerYear;
    }

    public String getUtmSource() {
        return this.utmSource;
    }

    public void setUtmSource(String utmSource) {
        this.utmSource = utmSource;
    }

    public Integer getStaffId() {
        return this.staffId;
    }

    public void setStaffId(Integer staffId) {
        this.staffId = staffId;
    }

    public Boolean getEnroll() {
        return this.enroll;
    }

    public void setEnroll(Boolean enroll) {
        this.enroll = enroll;
    }

    public Boolean getRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public String getDeregisterReason() {
        return this.deregisterReason;
    }

    public void setDeregisterReason(String deregisterReason) {
        this.deregisterReason = deregisterReason;
    }

    public String getMemberLevelDesc() {
        String memberLevelDesc = "";
        if (this.memberLevel == MemberLevelEnum.NORMAL.getCode()) {
            return MemberLevelEnum.NORMAL.getName();
        }
        if (this.memberLevel == MemberLevelEnum.VIP.getCode()) {
            memberLevelDesc = MemberLevelEnum.VIP.getName();
        } else if (this.memberLevel == MemberLevelEnum.VIP2.getCode()) {
            memberLevelDesc = MemberLevelEnum.VIP2.getName();
        } else if (this.memberLevel == MemberLevelEnum.VIP3.getCode()) {
            memberLevelDesc = MemberLevelEnum.VIP3.getName();
        } else if (this.memberLevel == MemberLevelEnum.VIP4.getCode()) {
            memberLevelDesc = MemberLevelEnum.VIP4.getName();
        }
        return memberLevelDesc;
    }

    public BigDecimal getBdayDiscountRatio() {
        BigDecimal discount = BigDecimal.valueOf(1L);
        if (this.getMemberLevel() == null) {
            return discount;
        }
        MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode((Integer)this.getMemberLevel());
        switch (memberLevel) {
            case VIP: {
                discount = BigDecimal.valueOf(0.95);
                break;
            }
            case VIP2: {
                discount = BigDecimal.valueOf(0.9);
                break;
            }
            case VIP3: {
                discount = BigDecimal.valueOf(0.85);
                break;
            }
            case VIP4: {
                discount = BigDecimal.valueOf(0.8);
            }
        }
        return discount;
    }

    private Date getThisYearBirthday() throws ParseException {
        if (this.birthday == null) {
            return null;
        }
        Integer year = DateUtil.thisYear();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat2.parse(year + "-" + simpleDateFormat.format(this.birthday) + " 00:00:00");
    }

    public boolean isInBdayDiscountTime() {
        if (this.birthday == null || this.memberLevel == null || MemberLevelEnum.NORMAL.getCode().equals(this.memberLevel)) {
            return false;
        }
        if (this.isBdayDiscountUsed()) {
            return false;
        }
        Date now = new Date();
        try {
            Date birthdayStartDate = this.getThisYearBirthday();
            Date birthdayExpireDate = this.getBirthdayExpireDate();
            Date beyondDate = this.getbeyongdDate();
            if (beyondDate != null && DateUtil.isIn((Date)beyondDate, (Date)now, (Date)birthdayStartDate)) {
                birthdayStartDate = DateUtil.offset((Date)birthdayStartDate, (DateField)DateField.YEAR, (int)-1);
                birthdayExpireDate = DateUtil.offset((Date)birthdayExpireDate, (DateField)DateField.YEAR, (int)-1);
            }
            return DateUtil.isIn((Date)now, (Date)birthdayStartDate, (Date)birthdayExpireDate);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBdayDiscountUsed() {
        if (this.birthday == null || this.memberLevel == null || this.birthdayDiscountYear == null) {
            return false;
        }
        if (MemberLevelEnum.NORMAL.getCode().equals(this.memberLevel)) {
            return false;
        }
        Integer useYear = DateUtil.thisYear();
        Date now = new Date();
        try {
            Date startDate = this.getThisYearBirthday();
            Date beyondDate = this.getbeyongdDate();
            if (beyondDate != null && DateUtil.isIn((Date)beyondDate, (Date)now, (Date)startDate)) {
                useYear = useYear - 1;
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65f6\u95f4\u89e3\u6790\u5f02\u5e38");
        }
        return this.birthdayDiscountYear.equals(useYear);
    }

    private Date getbeyongdDate() throws ParseException {
        MemberLevelEnum level = MemberLevelEnum.getEnumByCode((Integer)this.memberLevel);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Integer year = DateUtil.thisYear();
        Date beyondDate = null;
        switch (level) {
            case VIP: {
                beyondDate = simpleDateFormat2.parse(year + "-12-25 23:59:59");
                break;
            }
            case VIP2: 
            case VIP3: 
            case VIP4: {
                beyondDate = simpleDateFormat2.parse(year + "-12-18 23:59:59");
                break;
            }
        }
        return beyondDate;
    }

    private Date getBirthdayExpireDate() throws ParseException {
        Integer year = DateUtil.thisYear();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        MemberLevelEnum level = MemberLevelEnum.getEnumByCode((Integer)this.memberLevel);
        Date endDate = simpleDateFormat2.parse(year + "-" + simpleDateFormat.format(this.birthday) + " 23:59:59");
        switch (level) {
            case VIP: {
                endDate = DateUtil.offset((Date)endDate, (DateField)DateField.DAY_OF_YEAR, (int)6);
                break;
            }
            case VIP2: 
            case VIP3: 
            case VIP4: {
                endDate = DateUtil.offset((Date)endDate, (DateField)DateField.DAY_OF_YEAR, (int)13);
                break;
            }
        }
        return endDate;
    }
}

