/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.member.util;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.FileUtil;
import com.thebeastshop.member.enums.MergeTaskTypeEnum;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberMergeUtil {
    private static final Logger log = LoggerFactory.getLogger(MemberMergeUtil.class);
    private static final String ROOT_PATH = "/data/memberMergeData/";
    private static final String FILE_NAME = "data";
    private static final String MEMBER_PATH = "member/";
    private static final String CART_PATH = "cart/";
    private static final String COUPON_PATH = "coupon/";
    private static final String FAVOURITE_PATH = "favourite/";
    private static final String GIFT_CARD_PATH = "gift_card/";
    private static final String ID_CARD_PATH = "id_card/";
    private static final String MEMBER_ACCOUNT_PATH = "member_account/";
    private static final String MEMBER_ADDRESS_PATH = "member_address/";
    private static final String MEMBER_LOGIN_PATH = "member_login/";
    private static final String MEMBER_POINT_PATH = "member_point/";
    private static final String ORDER_PATH = "order/";
    private static final String PRIVILEGE_PATH = "privilege/";

    public static void saveToFile(Long taskId, Integer taskType, Object data) {
        MemberMergeUtil.saveToFile(taskId, taskType, Lists.newArrayList((Object[])new Object[]{data}));
    }

    public static void saveListToFile(Long taskId, Integer taskType, List<? extends Object> datas) {
        try {
            MergeTaskTypeEnum taskTypeEnum = MergeTaskTypeEnum.getEnumByCode(taskType);
            if (taskTypeEnum != null) {
                File file;
                StringBuilder saveDir = new StringBuilder(ROOT_PATH);
                switch (taskTypeEnum) {
                    case MEMBER_MERGE: {
                        saveDir.append(MEMBER_PATH);
                        break;
                    }
                    case CART_MERGE: {
                        saveDir.append(CART_PATH);
                        break;
                    }
                    case COUPON_MERGE: {
                        saveDir.append(COUPON_PATH);
                        break;
                    }
                    case FAVOURITE_MERGE: {
                        saveDir.append(FAVOURITE_PATH);
                        break;
                    }
                    case GIFT_CARD_MERGE: {
                        saveDir.append(GIFT_CARD_PATH);
                        break;
                    }
                    case ID_CARD_MERGE: {
                        saveDir.append(ID_CARD_PATH);
                        break;
                    }
                    case MEMBER_ACCOUNT_MERGE: {
                        saveDir.append(MEMBER_ACCOUNT_PATH);
                        break;
                    }
                    case MEMBER_ADDRESS_MERGE: {
                        saveDir.append(MEMBER_ADDRESS_PATH);
                        break;
                    }
                    case MEMBER_LOGIN_MERGE: {
                        saveDir.append(MEMBER_LOGIN_PATH);
                        break;
                    }
                    case MEMBER_POINT_MERGE: {
                        saveDir.append(MEMBER_POINT_PATH);
                        break;
                    }
                    case ORDER_MERGE: {
                        saveDir.append(ORDER_PATH);
                        break;
                    }
                    case PRIVILEGE_MERGE: {
                        saveDir.append(PRIVILEGE_PATH);
                        break;
                    }
                    default: {
                        saveDir.append("unknown/");
                    }
                }
                File dir = new File(saveDir.toString());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((file = new File(dir.getPath() + "/" + FILE_NAME + "_" + taskId)).exists()) {
                    file.delete();
                }
                ArrayList list = Lists.newArrayList();
                StringBuilder dataStr = null;
                for (Object object : datas) {
                    Field[] fields;
                    dataStr = new StringBuilder();
                    Class<?> clazz = object.getClass();
                    for (Field field : fields = clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object value = field.get(object);
                        if (value != null) {
                            if (field.getType().equals(Date.class)) {
                                dataStr.append(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(value));
                            } else {
                                dataStr.append(value);
                            }
                        } else {
                            dataStr.append(" ");
                        }
                        dataStr.append("|");
                    }
                    list.add(dataStr.toString());
                }
                FileUtil.writeList2File((List)list, (File)file);
            }
        }
        catch (Exception e) {
            log.error("\u5408\u5e76\u4fe1\u606f\u4fdd\u5b58\u5230\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }
}

