package com.thebeastshop.media.service;

import com.thebeastshop.media.req.SaveTraceEventReq;
import com.thebeastshop.media.vo.TraceEventVO;
import com.thebeastshop.media.vo.TraceVO;

/**
 * @Author zhaoqing.chen
 * @Date 2020/9/8
 * @Description
 */
public interface TraceService {

    /**
     * 根据id取打点参数
     *
     * @param id
     * @return
     */
    TraceVO getParamById(Long id);

    /**
     * 保存打点参数
     *
     * @param req
     * @return
     */
    Long saveTrace(TraceVO req);

    /**
     * 保存打点事件
     *
     * @param req
     * @return
     */
    Integer saveTraceEvent(SaveTraceEventReq req);

    /**
     * 查询打点事件
     *
     * @param memberCode
     * @param hours
     * @return
     */
    TraceEventVO getTraceEvent(String memberCode, Integer hours);
}
