package com.thebeastshop.media.service;

import com.thebeastshop.media.dto.MediaInfoReq;
import com.thebeastshop.media.vo.MediaVO;

import javax.print.attribute.standard.Media;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * @Author: alexzchen
 * @Date: Created in 2018/7/26
 * @Description: 媒体上传服务
 */
public interface MediaService {

    /**
     * 根据id，返回媒体文件对象
     * @param id
     * @return
     */
    MediaVO getMediaById(Integer id);

    /**
     * 根据id列表，返回媒体对象Map
     * @param ids
     * @return
     */
    Map<Integer, MediaVO> getMedias(List<Integer> ids);

    /**
     * 保存媒体对象信息
     * @param mediaInfoReq
     * @return
     */
    MediaVO saveMediaInfo(MediaInfoReq mediaInfoReq);

    /**
     * 批量保存媒体对象信息
     * @param mediaInfoReqs
     * @return
     */
    List<MediaVO> batchSaveMediaInfo(List<MediaInfoReq> mediaInfoReqs);

}
