package com.thebeastshop.media.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.media.resp.ImageScanResult;
import com.thebeastshop.media.resp.TextScanResult;
import com.thebeastshop.media.resp.VideoScanResult;

import java.util.List;

/**
 * @ClassName: MediaScanService
 * @Description: 媒体扫描服务
 * @author: Xiang.Gao
 * @date: 2020/8/12 15:08
 */
public interface MediaScanService {

    /**
     * 文本鉴定
     */
    public ServiceResp<TextScanResult> textSan(List<String> contents);

    /**
     * 图片扫描
     */
    public ServiceResp<ImageScanResult> imageScan(List<String> fileUrls);

    /**
     * 视频异步鉴定
     */
    public ServiceResp<String> commitVideoAsyncScan(String fileUrl);

    /**
     * 获取视频检测结果
     */
    public ServiceResp<VideoScanResult> getVideoScanResult(String taskId);


}
