package com.thebeastshop.media.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.media.req.ProductArticleShareImageReq;
import com.thebeastshop.media.req.ProductDetailShareImageReq;
import com.thebeastshop.media.req.ProductListShareImageReq;
import com.thebeastshop.media.vo.ShareImageVO;

/**
 * @Author: alexzchen
 * @Date: Created in 2019/07/03
 * @Description: 图片合成服务
 **/

public interface ImageCombineService {

    /**
     * 购买成功商品分享图
     * @param productName
     * @param brandName
     * @param productImage
     * @return
     */
    ServiceResp<String> orderProductShareImage(String productName, String brandName, String productImage);

    /**
     * 有趣话题分享图
     * @param topicId 话题ID
     * @param topicTitle 话题标题
     * @param topicContent 话题内容
     * @param topicImageUrl 话题图片
     * @return
     */
    ServiceResp<String> funnyTopicShareImage(Integer topicId, String topicTitle, String topicContent, String topicImageUrl);

    /**
     * 有趣帖子分享图
     * @param postId
     * @param avatarUrl
     * @param nickName
     * @param postContent
     * @param postImageUrl
     * @return
     */

    ServiceResp<String> funnyPostShareImage(Integer postId, String avatarUrl, String nickName, String postContent, String postImageUrl);

    /**
     * 商品详情分享图片
     * @param req
     * @return
     */
    ServiceResp<ShareImageVO> productDetailShareImage(ProductDetailShareImageReq req);

    /**
     * 商品列表分享图片
     * @param req
     * @return
     */
    ServiceResp<ShareImageVO> productListShareImage(ProductListShareImageReq req);

    /**
     * 商品专题分享图片
     * @param req
     * @return
     */
    ServiceResp<ShareImageVO> productArticleShareImage(ProductArticleShareImageReq req);
}
