package com.thebeastshop.media.resp;

/**
 * @ClassName: VideoScanResult
 * @Description: 视频扫描结果
 * @author: Xiang.Gao
 * @date: 2020/8/14 16:04
 */
public class VideoScanResult extends BaseScanResult {

    /**
     * 处理状态
     */
    private String state;

    /**
     * 视频在每个场景下的识别结果
     */
    private UrlScanResultInfo urlScanResultInfo;

    public VideoScanResult(String state){
        this.state = state;
    }

    public VideoScanResult(String state, UrlScanResultInfo urlScanResultInfo) {
        this.state = state;
        this.urlScanResultInfo = urlScanResultInfo;
    }

    public VideoScanResult(String state, Boolean legal, UrlScanResultInfo urlScanResultInfo, String description) {
        this.state = state;
        this.legal = legal;
        this.urlScanResultInfo = urlScanResultInfo;
        this.description = description;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Boolean getLegal() {
        return legal;
    }

    public void setLegal(Boolean legal) {
        this.legal = legal;
    }

    public UrlScanResultInfo getUrlScanResultInfo() {
        return urlScanResultInfo;
    }

    public void setUrlScanResultInfo(UrlScanResultInfo urlScanResultInfo) {
        this.urlScanResultInfo = urlScanResultInfo;
    }
}
