package com.thebeastshop.media.enums;

/**
 * @ClassName: VideoScanState
 * @Description: 视频鉴定状态
 * @author: Xiang.Gao
 * @date: 2020/8/14 17:16
 */
public enum VideoScanState {

    SUCCESS("success", "成功"),
    FAILED("failed", "失败"),
    WAITING("wait", "等待");

    private String code;
    private String name;

    VideoScanState(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public VideoScanState getByCode(String code) {
        for(VideoScanState state : VideoScanState.values()) {
            if (state.getCode().equals(code)) {
                return state;
            }
        }
        return null;
    }
}
