package com.thebeastshop.media.enums;

/**
 * @ClassName: SuggestionEnum
 * @Description: 建议枚举
 * @author: Xiang.Gao
 * @date: 2020/8/12 16:48
 */
public enum SuggestionEnum {

    PASS("pass", "正常或者未识别出目标对象，无需进行其余操作"),
    REVIEW("review", "检测结果不确定或者识别出目标对象，需要进行人工审核"),
    BLOCK("block", "违规，建议执行进一步操作");

    private String code;
    private String descrtion;

    SuggestionEnum(String code, String descrtion) {
        this.code = code;
        this.descrtion = descrtion;
    }

    public String getCode() {
        return code;
    }

    public String getDescrtion() {
        return descrtion;
    }

    public static SuggestionEnum getByCode(String code) {
        for (SuggestionEnum suggestion : SuggestionEnum.values()) {
            if (suggestion.getCode().equals(code)) {
                return suggestion;
            }
        }
        return null;
    }

}
