package com.thebeastshop.media.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.FileTypeEnum;

import java.util.List;

/**
 * @Author: alexzchen
 * @Date: Created in 2017/12/5
 * @Description:
 */
public enum MediaType {
    IMAGE(0, "图片", Lists.newArrayList(FileTypeEnum.GIF, FileTypeEnum.JPG, FileTypeEnum.PNG),"app_image"),
    VIDEO(1,"视频", Lists.newArrayList(FileTypeEnum.MP4, FileTypeEnum.AVI),"app_video"),
    AUDIO(2,"音频", Lists.newArrayList(FileTypeEnum.MP3, FileTypeEnum.WAV),"app_audio");

    private Integer code;

    private String name;

    private List<FileTypeEnum> fileTypeEnums;

    private String extraPath;

    MediaType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }


    MediaType(Integer code, String name, List<FileTypeEnum> fileTypeEnums) {
        this.code = code;
        this.name = name;
        this.fileTypeEnums = fileTypeEnums;
    }


    MediaType(Integer code, String name, List<FileTypeEnum> fileTypeEnums, String extraPath) {
        this.code = code;
        this.name = name;
        this.fileTypeEnums = fileTypeEnums;
        this.extraPath= extraPath;
    }

    public Boolean fileTypeContains(FileTypeEnum fileTypeEnum){
        return this.fileTypeEnums.contains(fileTypeEnum);
    }


    public static MediaType getMediaByFileType(FileTypeEnum fileTypeEnum){
        for (MediaType mediaType : values()) {
            if(mediaType.fileTypeContains(fileTypeEnum)){
                return mediaType;
            }
        }
        return null;
    }

    public static MediaType getMediaByCode(Integer code){
        for (MediaType mediaType : values()) {
            if(mediaType.getCode().equals(code)){
                return mediaType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getExtraPath() {
        return extraPath;
    }
}
