package com.thebeastshop.media.dto;

import java.io.Serializable;

/**
 * @ClassName: VideoCutReq
 * @Description: 文件描述...
 * @author: Xiang.Gao
 * @date: 2020/8/24 11:41
 */
public class VideoCutReq implements Serializable {

    /**
     * 视频地址
     */
    private String fileUrl;

    /**
     * 剪辑次数
     */
    private Integer cutCount;

    /**
     * 间隔时间(毫秒)
     */
    private Integer intervalMill;

    /**
     * 宽带
     */
    private Integer width;

    /**
     * 高度
     */
    private Integer height;

    public VideoCutReq(String fileUrl, Integer width, Integer height) {
        this.fileUrl = fileUrl;
        this.width = width;
        this.height = height;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Integer getCutCount() {
        return cutCount;
    }

    public void setCutCount(Integer cutCount) {
        this.cutCount = cutCount;
    }

    public Integer getIntervalMill() {
        return intervalMill;
    }

    public void setIntervalMill(Integer intervalMill) {
        this.intervalMill = intervalMill;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return "VideoCutReq{" +
                "fileUrl='" + fileUrl + '\'' +
                ", cutCount=" + cutCount +
                ", intervalMill=" + intervalMill +
                ", width=" + width +
                ", height=" + height +
                '}';
    }
}
