/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.seata.utils;

import com.thebeastshop.common.utils.BeanUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TccHelper {
    private static final Map<String, Map<String, Object>> tryResults = new ConcurrentHashMap<String, Map<String, Object>>();

    public static void tryResult(String txId, String name, Object result) {
        Map map = tryResults.computeIfAbsent(txId, key -> new ConcurrentHashMap());
        map.put(name, result);
    }

    public static boolean canRollback(String txId) {
        return tryResults.containsKey(txId);
    }

    public static boolean canNotRollback(String txId) {
        return !TccHelper.canRollback(txId);
    }

    public static Object getTryResult(String txId, String name) {
        if (tryResults.containsKey(txId)) {
            return tryResults.get(name);
        }
        return null;
    }

    public static <T> T getTryResult(String txId, String name, Class<T> cls) {
        Object obj = TccHelper.getTryResult(txId, name);
        if (obj == null) {
            return null;
        }
        if (cls.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return (T)BeanUtil.buildFrom((Object)obj, cls);
    }

    public static void commitSuccess(String txId) {
        tryResults.remove(txId);
    }

    public static void rollback(String txId) {
        tryResults.remove(txId);
    }
}

