package com.thebeastshop.kit.seata.utils;

import com.thebeastshop.common.utils.BeanUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TccHelper {

    private final static Map<String, Map<String, Object>> tryResults = new ConcurrentHashMap<>();


    public static void tryResult(final String txId, final String name, final Object result) {
        final Map<String, Object> map = tryResults.computeIfAbsent(txId, key -> new ConcurrentHashMap<>());
        map.put(name, result);
    }

    public static boolean canRollback(final String txId) {
        return tryResults.containsKey(txId);
    }

    public static boolean canNotRollback(final String txId) {
        return !canRollback(txId);
    }


    public static Object getTryResult(final String txId, final String name) {
        if (tryResults.containsKey(txId)) {
            return tryResults.get(name);
        }
        return null;
    }

    public static <T> T getTryResult(final String txId, final String name, final Class<T> cls) {
        final Object obj = getTryResult(txId, name);
        if (obj == null) {
            return null;
        }
        if (cls.isAssignableFrom(obj.getClass())) {
            return (T) obj;
        }
        return BeanUtil.buildFrom(obj, cls);
    }

    public static void commitSuccess(final String txId) {
        tryResults.remove(txId);
    }

    public static void rollback(final String txId) {
        tryResults.remove(txId);
    }


}
