/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.enums.ExcelCellTypeEnum;
import com.thebeastshop.common.exception.UtilException;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.ExcelCellStyle;
import com.thebeastshop.common.utils.ExcelRowCellTemplate;
import com.thebeastshop.common.utils.ExcelRowTemplate;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.common.utils.ScopeUtil;
import com.thebeastshop.common.utils.XSSFDateUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static byte[] write(String sheetName, List<List<String>> allLines, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            for (int j = 0; j < line.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                cell.setCellValue(line.get(j));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static byte[] Excel2007AboveOperate(String sheetName, List<ExcelRowTemplate> allLines, boolean oldVersion) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(100);
        SXSSFSheet sheet = sxssfWorkbook.createSheet(sheetName);
        Row row = null;
        XSSFCellStyle style = (XSSFCellStyle)sxssfWorkbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            row = sheet.createRow(i);
            ExcelRowTemplate line = allLines.get(i);
            List<ExcelRowCellTemplate> cells = line.getCells();
            boolean isNullLine = line == null || cells.size() == 0;
            for (int j = 0; j < cells.size(); ++j) {
                Cell cell = row.createCell(j);
                ExcelRowCellTemplate cellTemplate = cells.get(j);
                String cellValue = cellTemplate.getCellValue();
                ExcelCellStyle cellStyle = cellTemplate.getStyle();
                if (cellStyle != null) {
                    style.setFillForegroundColor(cellStyle.getFillForegroundColor().shortValue());
                    style.setFillPattern(cellStyle.getFillPattern());
                }
                cell.setCellStyle((CellStyle)style);
                cell.setCellValue(isNullLine ? "" : (cellValue == null ? "" : cellValue));
            }
        }
        try {
            sxssfWorkbook.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static byte[] writeBigData(String sheetName, List<List<String>> allLines) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        SXSSFSheet sheet = sxssfWorkbook.createSheet(sheetName);
        Row row = null;
        for (int i = 0; i < allLines.size(); ++i) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            for (int j = 0; j < line.size(); ++j) {
                String cellValue = line.get(j);
                Cell cell = row.createCell(j);
                cell.setCellValue(cellValue == null ? "" : cellValue);
            }
        }
        try {
            sxssfWorkbook.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public ByteArrayOutputStream writeToZip(String sheetName, List<List<String>> allLines, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            for (int j = 0; j < line.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                cell.setCellValue(line.get(j));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os;
    }

    public static byte[] writeImgExcel(String sheetName, List<List<String>> allLines, boolean oldVersion) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            Cell cell;
            int j;
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            if (i >= 1) {
                row.setHeight((short)1500);
                for (j = 0; j < line.size(); ++j) {
                    if (j == 2 || j == 3 || j == 6) {
                        sheet.setColumnWidth(j, 6000);
                    } else if (j == 5) {
                        sheet.setColumnWidth(j, 4500);
                    } else {
                        sheet.setColumnWidth(j, 3000);
                    }
                    if (j == 9) {
                        try {
                            if (line.get(j) != "") {
                                BufferedImage bufferImg = null;
                                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                                URL url = new URL(line.get(j));
                                Image src = Toolkit.getDefaultToolkit().getImage(url);
                                bufferImg = ExcelUtil.toBufferedImage(src);
                                ImageIO.write((RenderedImage)bufferImg, "jpg", byteArrayOut);
                                HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, 9, i, 10, i + 1);
                                anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
                                patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), 5));
                                continue;
                            }
                            cell = row.createCell(j);
                            cell.setCellType(1);
                            cell.setCellValue(line.get(j));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    cell = row.createCell(j);
                    cell.setCellType(1);
                    cell.setCellValue(line.get(j));
                }
                continue;
            }
            for (j = 0; j < line.size(); ++j) {
                cell = row.createCell(j);
                cell.setCellType(1);
                cell.setCellValue(line.get(j));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static byte[] write(Map<String, List<List<String>>> sheets, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Set<String> sheetNames = sheets.keySet();
        for (String sheetName : sheetNames) {
            List<List<String>> allLines = sheets.get(sheetName);
            Sheet sheet = wb.createSheet(sheetName);
            Row row = sheet.createRow(0);
            CellStyle style = wb.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setWrapText(true);
            for (int i = 0; i < allLines.size(); ++i) {
                row = sheet.createRow(i);
                List<String> line = allLines.get(i);
                for (int j = 0; j < line.size(); ++j) {
                    Cell cell = row.createCell(j);
                    cell.setCellType(1);
                    cell.setCellValue(line.get(j));
                }
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static List<List<String>> read(InputStream is, boolean oldVersion) {
        return ExcelUtil.read(is, 0, oldVersion);
    }

    public static List<List<String>> read(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sheet = workbook.getSheetAt(page);
        int headLength = 0;
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            ArrayList<String> line;
            row = sheet.getRow(i);
            if (row != null) {
                line = new ArrayList<String>();
                if (row.getPhysicalNumberOfCells() > headLength) {
                    headLength = row.getPhysicalNumberOfCells();
                }
                for (int j = 0; j < headLength; ++j) {
                    cell = row.getCell(j);
                    String cellValue = ExcelUtil.getCellValue(cell);
                    line.add(EmptyUtil.isNotEmpty((String)cellValue) ? cellValue.trim() : "");
                }
            } else {
                throw new RuntimeException("Excel\u4e2d,\u7b2c" + (i + 1) + "\u884c\u662f\u7a7a\u884c\uff0c\u8bf7\u5220\u9664");
            }
            allLines.add(line);
        }
        return allLines;
    }

    public static String getCellValue(Cell cell) {
        if (NullUtil.isNull((Object)cell)) {
            return "";
        }
        if (2 == cell.getCellType()) {
            throw new UtilException("UT2000", String.format("%s\u884c%s\u5217\u5b58\u5728\u516c\u5f0f\uff0c\u65e0\u6cd5\u4e0a\u4f20", cell.getRowIndex() + 1, cell.getColumnIndex() + 1));
        }
        String value = null;
        NumberFormat nf = NumberFormat.getInstance();
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                if (XSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = DateUtil.format((Date)HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()), (String)"yyyy-MM-dd HH:mm:ss");
                    break;
                }
                Long l = Double.valueOf(cell.getNumericCellValue()).longValue();
                Double d = cell.getNumericCellValue();
                if (new BigDecimal(l).compareTo(new BigDecimal(d)) == 0) {
                    value = String.valueOf(d.longValue());
                    break;
                }
                value = String.valueOf(d);
                break;
            }
            case 2: {
                Workbook wb = cell.getSheet().getWorkbook();
                CreationHelper crateHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
                value = ExcelUtil.getCellValue(evaluator.evaluateInCell(cell));
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                value = "";
                break;
            }
        }
        return value;
    }

    public static Map<String, List<List<String>>> readMultipleSheet(InputStream is, int pageNum, boolean oldVersion) {
        HSSFWorkbook workbook = null;
        HashMap<String, List<List<String>>> sheetMap = new HashMap<String, List<List<String>>>();
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            for (int i = 0; i < pageNum; ++i) {
                sheetMap.put(i + "", ExcelUtil.readSheet(workbook.getSheetAt(i)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sheetMap;
    }

    public static Map<String, List<List<String>>> readMultipleSheet(InputStream is, boolean oldVersion) {
        HSSFWorkbook workbook = null;
        HashMap<String, List<List<String>>> sheetMap = new HashMap<String, List<List<String>>>();
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            int sheetNumber = workbook.getNumberOfSheets();
            for (int i = 0; i < sheetNumber; ++i) {
                sheetMap.put(workbook.getSheetName(i), ExcelUtil.readSheet(workbook.getSheetAt(i)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sheetMap;
    }

    public static List<List<String>> readSheet(Sheet sheet) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        Row row = null;
        Cell cell = null;
        int headLength = 0;
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            ArrayList<String> line = new ArrayList<String>();
            if (row.getPhysicalNumberOfCells() > headLength) {
                headLength = row.getPhysicalNumberOfCells();
            }
            for (int j = 0; j < headLength; ++j) {
                cell = row.getCell(j);
                String cellValue = ExcelUtil.getCellValue(cell);
                line.add(EmptyUtil.isNotEmpty((String)cellValue) ? cellValue.trim() : "");
            }
            allLines.add(line);
        }
        return allLines;
    }

    public static List<List<String>> readProdSku(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                ArrayList<String> line = new ArrayList<String>();
                for (int j = 0; j < 2; ++j) {
                    cell = row.getCell(j);
                    String cellValue = ExcelUtil.getCellValue(cell);
                    line.add(EmptyUtil.isNotEmpty((String)cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        return allLines;
    }

    public static List<List<String>> readNormal(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                ArrayList<String> line = new ArrayList<String>();
                for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
                    cell = row.getCell(j);
                    String cellValue = ExcelUtil.getCellValue(cell);
                    line.add(EmptyUtil.isNotEmpty((String)cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        return allLines;
    }

    public static byte[] writeImgExcelNew(String sheetName, List<List<String[]>> allLines) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        for (int i = 0; i < allLines.size(); ++i) {
            int j;
            row = sheet.createRow(i);
            log.info("writeImgExcelNew:sku_code={}", (Object)allLines.get(i).get(0)[0]);
            List<String[]> line = allLines.get(i);
            if (i >= 1) {
                row.setHeight((short)1500);
                for (j = 0; j < line.size(); ++j) {
                    Cell cell;
                    String[] cellInfo;
                    block13: {
                        cellInfo = line.get(j);
                        cell = row.createCell(j);
                        if (Integer.valueOf(cellInfo[1]).intValue() == ExcelCellTypeEnum.TYPE_STRING.getCode()) {
                            sheet.setColumnWidth(j, 6000);
                            cellStyle.setWrapText(true);
                            cell.setCellType(1);
                            cell.setCellStyle((CellStyle)cellStyle);
                            cell.setCellValue((RichTextString)new HSSFRichTextString(cellInfo[0]));
                        }
                        if (Integer.valueOf(cellInfo[1]).intValue() == ExcelCellTypeEnum.TYPE_IMAGE.getCode()) {
                            sheet.setColumnWidth(j, 3500);
                            if (!ObjectUtils.isEmpty((Object)cellInfo[0])) {
                                try {
                                    File imagefile = new File(cellInfo[0]);
                                    if (imagefile.length() < 0x100000L) {
                                        BufferedImage bufferImg = null;
                                        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                                        URL url = new URL(cellInfo[0]);
                                        Image src = Toolkit.getDefaultToolkit().getImage(url);
                                        bufferImg = ExcelUtil.toBufferedImage(src);
                                        ImageIO.write((RenderedImage)bufferImg, "jpg", byteArrayOut);
                                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)j, (int)((short)i), (short)(j + 1), (int)((short)(i + 1)));
                                        anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
                                        patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), 5));
                                        break block13;
                                    }
                                    cell.setCellType(1);
                                    cell.setCellValue(cellInfo[0]);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                    cell.setCellType(1);
                                    cell.setCellValue(cellInfo[0]);
                                }
                            } else {
                                cell.setCellType(1);
                                cell.setCellValue("");
                            }
                        }
                    }
                    if (Integer.valueOf(cellInfo[1]).intValue() != ExcelCellTypeEnum.TYPE_NUMBER.getCode()) continue;
                    HSSFDataFormat df = wb.createDataFormat();
                    cellStyle.setDataFormat(df.getFormat("#,#0.00"));
                    cell.setCellType(0);
                    cell.setCellStyle((CellStyle)cellStyle);
                    cell.setCellValue(Double.valueOf(cellInfo[0]).doubleValue());
                }
                continue;
            }
            for (j = 0; j < line.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                cell.setCellValue((RichTextString)new HSSFRichTextString(line.get(j)[0]));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static final byte[] insertRows(File file, String sheetName, List<ExcelRowTemplate> rows) {
        XSSFWorkbook wb = ExcelUtil.returnWorkBookGivenFileHandle(file);
        return ExcelUtil.insertRows(wb, sheetName, rows);
    }

    public static final byte[] insertRows(InputStream fis, String sheetName, List<ExcelRowTemplate> rows) {
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook(fis);
        }
        catch (IOException e) {
            try {
                fis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return ExcelUtil.insertRows(wb, sheetName, rows);
    }

    public static final byte[] insertRows(XSSFWorkbook wb, String sheetName, List<ExcelRowTemplate> rows) {
        XSSFSheet sheet1 = wb.getSheet(sheetName);
        if (sheet1 == null) {
            sheet1 = wb.createSheet(sheetName);
        }
        int rowTotal = rows.size();
        for (int i = 0; i < rowTotal; ++i) {
            ExcelRowTemplate rowTemplate = rows.get(i);
            if (rowTemplate.isInsertRow()) {
                sheet1.shiftRows(rowTemplate.getRowNum(), sheet1.getLastRowNum(), 1, true, false);
            }
            ExcelUtil.insertCells(wb, sheet1, rowTemplate.getCells(), rowTemplate.isAutoRowHeight());
        }
        return ExcelUtil.saveExcel(wb);
    }

    public static XSSFWorkbook insertRowsV2(XSSFWorkbook wb, String sheetName, List<ExcelRowTemplate> rows) {
        XSSFSheet sheet1 = wb.getSheet(sheetName);
        if (sheet1 == null) {
            sheet1 = wb.createSheet(sheetName);
        }
        int rowTotal = rows.size();
        for (int i = 0; i < rowTotal; ++i) {
            ExcelRowTemplate rowTemplate = rows.get(i);
            if (rowTemplate.isInsertRow()) {
                sheet1.shiftRows(rowTemplate.getRowNum(), sheet1.getLastRowNum(), 1, true, false);
            }
            ExcelUtil.insertCells(wb, sheet1, rowTemplate.getCells(), rowTemplate.isAutoRowHeight());
        }
        return wb;
    }

    public static final byte[] insertRows(File file, Map<String, List<ExcelRowTemplate>> sheetFileMap) {
        XSSFWorkbook wb = ExcelUtil.returnWorkBookGivenFileHandle(file);
        for (Map.Entry<String, List<ExcelRowTemplate>> entry : sheetFileMap.entrySet()) {
            XSSFSheet sheet1 = wb.getSheet(entry.getKey());
            List<ExcelRowTemplate> rows = entry.getValue();
            ExcelUtil.writeSheet(rows, sheet1, wb);
        }
        return ExcelUtil.saveExcel(wb);
    }

    public static void writeSheet(List<ExcelRowTemplate> rows, XSSFSheet sheet1, XSSFWorkbook wb) {
        int rowTotal = rows.size();
        for (int i = 0; i < rowTotal; ++i) {
            ExcelRowTemplate rowTemplate = rows.get(i);
            if (rowTemplate.isInsertRow()) {
                sheet1.shiftRows(rowTemplate.getRowNum(), sheet1.getLastRowNum(), 1, true, false);
            }
            ExcelUtil.insertCells(wb, sheet1, rowTemplate.getCells(), rowTemplate.isAutoRowHeight());
        }
    }

    public static void insertCells(XSSFWorkbook wb, XSSFSheet sheet1, List<ExcelRowCellTemplate> cellTemplates, boolean isAutoRowHeight) {
        int cellTotal = cellTemplates.size();
        for (int i = 0; i < cellTotal; ++i) {
            ExcelUtil.createCell(wb, sheet1, cellTemplates.get(i), isAutoRowHeight);
        }
    }

    public static byte[] saveExcel(XSSFWorkbook wb) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
            wb.close();
            os.flush();
            os.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    private static XSSFCell createCell(XSSFWorkbook wb, XSSFSheet sheet, ExcelRowCellTemplate cellTemplate, boolean isAutoRowHeight) {
        int rowNum = cellTemplate.getRowNum();
        XSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            row = sheet.createRow(rowNum);
        }
        if (isAutoRowHeight) {
            CTRow ctRow = row.getCTRow();
            ctRow.setCustomHeight(false);
        }
        int columnIndex = cellTemplate.getColumnIndex();
        XSSFCell cell = row.createCell(cellTemplate.getColumnIndex());
        CellRangeAddress cellRangeAddress = null;
        if (cellTemplate.isWhetherToMergeCells()) {
            ArrayList haveCellRangeAddressList;
            int startColIndex = cellTemplate.getFirstCol() == null ? columnIndex : cellTemplate.getFirstCol();
            int endColIndex = cellTemplate.getLastCol() == null ? columnIndex : cellTemplate.getLastCol();
            int startRowIndex = cellTemplate.getFirstRow() == null ? rowNum : cellTemplate.getFirstRow();
            int endRowIndex = cellTemplate.getLastRow() == null ? rowNum : cellTemplate.getLastRow();
            cellRangeAddress = new CellRangeAddress(startRowIndex, endRowIndex, startColIndex, endColIndex);
            List cellRangeAddressList = sheet.getMergedRegions();
            List<Object> list = haveCellRangeAddressList = EmptyUtil.isNotEmpty((List)cellRangeAddressList) ? cellRangeAddressList.stream().filter(x -> ScopeUtil.isIntersection(x.getFirstColumn(), x.getLastColumn(), startColIndex, endColIndex) && ScopeUtil.isIntersection(x.getFirstRow(), x.getLastRow(), startRowIndex, endRowIndex)).collect(Collectors.toList()) : new ArrayList();
            if (EmptyUtil.isEmpty(haveCellRangeAddressList)) {
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
        XSSFCellStyle style = wb.createCellStyle();
        if (cellTemplate.getAlignCenter() != null) {
            style.setAlignment(HorizontalAlignment.CENTER);
        }
        if (cellTemplate.getVerticalCenter() != null) {
            style.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        if (cellTemplate.getFillPattern() != null) {
            style.setFillPattern(FillPatternType.forInt((int)cellTemplate.getFillPattern().shortValue()));
        }
        if (cellTemplate.getFillForegroundColor() != null) {
            style.setFillForegroundColor(cellTemplate.getFillForegroundColor().shortValue());
        }
        ExcelCellStyle excelCellStyle = cellTemplate.getStyle();
        XSSFFont font = wb.createFont();
        if (cellTemplate.getFontSize() != null) {
            font.setFontHeightInPoints(cellTemplate.getFontSize().shortValue());
        }
        if (cellTemplate.getFontName() != null) {
            font.setFontName(cellTemplate.getFontName());
        }
        if (excelCellStyle != null) {
            if (excelCellStyle.getBorderLeft() != null) {
                style.setBorderLeft(excelCellStyle.getBorderLeft());
                if (cellRangeAddress != null) {
                    RegionUtil.setBorderLeft((int)1, (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
                }
            }
            if (excelCellStyle.getBorderRight() != null) {
                style.setBorderRight(excelCellStyle.getBorderRight());
                if (cellRangeAddress != null) {
                    RegionUtil.setBorderRight((int)1, (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
                }
            }
            if (excelCellStyle.getBorderBottom() != null) {
                style.setBorderBottom(excelCellStyle.getBorderBottom());
                if (cellRangeAddress != null) {
                    RegionUtil.setBorderBottom((int)1, (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
                }
            }
            if (excelCellStyle.getBorderTop() != null) {
                style.setBorderTop(excelCellStyle.getBorderTop());
                if (cellRangeAddress != null) {
                    RegionUtil.setBorderTop((int)1, (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
                }
            }
            if (excelCellStyle.getFontSize() != null) {
                font.setFontHeightInPoints(excelCellStyle.getFontSize().shortValue());
            }
            if (excelCellStyle.getFontName() != null) {
                font.setFontName(excelCellStyle.getFontName());
            }
            if (excelCellStyle.getAlignment() != null) {
                style.setAlignment(excelCellStyle.getAlignment());
            }
            style.setWrapText(excelCellStyle.isWrapText());
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setWrapText(excelCellStyle.isWrapText());
            byte[] rgb = new byte[]{89, 89, 89};
            XSSFColor color = new XSSFColor(new Color(89, 89, 89));
            style.setLeftBorderColor(color);
            style.setBottomBorderColor(color);
            if (excelCellStyle.getColor() != null) {
                font.setColor(excelCellStyle.getColor().shortValue());
            }
            if (excelCellStyle.getFillForegroundColor() != null) {
                style.setFillForegroundColor(excelCellStyle.getFillForegroundColor().shortValue());
            }
            if (excelCellStyle.getFillPattern() != null) {
                style.setFillPattern(excelCellStyle.getFillPattern());
            }
        }
        style.setFont((Font)font);
        cell.setCellStyle((CellStyle)style);
        if (cellTemplate.isLink()) {
            try {
                row.setHeightInPoints(50.0f);
                URL url = new URL(cellTemplate.getCellValue());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(50000);
                InputStream inStream = conn.getInputStream();
                byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
                int pictureIdx = wb.addPicture(bytes, 6);
                XSSFCreationHelper helper = wb.getCreationHelper();
                XSSFDrawing drawing = sheet.createDrawingPatriarch();
                ClientAnchor anchor = helper.createClientAnchor();
                anchor.setDx1(0);
                anchor.setDy1(0);
                anchor.setDx2(0);
                anchor.setDy2(0);
                anchor.setCol1(cellTemplate.getColumnIndex());
                anchor.setCol2(cellTemplate.getColumnIndex() + 1);
                anchor.setRow1(rowNum);
                anchor.setRow2(rowNum + 1);
                Picture pict = drawing.createPicture(anchor, pictureIdx);
                pict.resize(1.0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            cell.setCellValue(cellTemplate.getCellValue());
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSSFWorkbook returnWorkBookGivenFileHandle(File f) {
        XSSFWorkbook wb = null;
        FileInputStream fis = null;
        try {
            if (f != null) {
                fis = new FileInputStream(f);
                wb = new XSSFWorkbook((InputStream)fis);
            }
        }
        catch (Exception e) {
            XSSFWorkbook xSSFWorkbook = null;
            return xSSFWorkbook;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSSFWorkbook returnWorkBookGivenFileHandle(FileInputStream fis) {
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook((InputStream)fis);
        }
        catch (Exception e) {
            XSSFWorkbook xSSFWorkbook = null;
            return xSSFWorkbook;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return wb;
    }

    private XSSFRow createRow(XSSFSheet sheet, ExcelRowTemplate rowTemplate) {
        int rowIndex = rowTemplate.getRowNum();
        XSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            int lastRowNo = sheet.getLastRowNum();
            sheet.shiftRows(rowIndex, lastRowNo, 1);
        }
        row = sheet.createRow(rowIndex);
        return row;
    }

    private XSSFRow getRow(XSSFSheet sheet, Integer rowIndex) {
        return sheet.getRow(rowIndex.intValue());
    }

    public static void main(String[] args) throws Exception {
        XSSFWorkbook my_workbook = new XSSFWorkbook();
        XSSFSheet my_sheet = my_workbook.createSheet("MyBanner");
        FileInputStream my_banner_image = new FileInputStream("D:\\10010001_thumb.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)my_banner_image);
        int my_picture_id = my_workbook.addPicture(bytes, 5);
        ((InputStream)my_banner_image).close();
        XSSFDrawing drawing = my_sheet.createDrawingPatriarch();
        XSSFClientAnchor my_anchor = new XSSFClientAnchor();
        my_anchor.setCol1(2);
        my_anchor.setRow1(1);
        XSSFPicture my_picture = drawing.createPicture((ClientAnchor)my_anchor, my_picture_id);
        my_picture.resize();
        FileOutputStream out = new FileOutputStream(new File("D:\\excel_insert_image_example.xlsx"));
        my_workbook.write((OutputStream)out);
        out.close();
    }

    public static byte[] write(String sheetName, List<ExcelRowTemplate> rows) {
        XSSFWorkbook wb = new XSSFWorkbook();
        return ExcelUtil.insertRows(wb, sheetName, rows);
    }

    public static byte[] writeImgExcel(String sheetName, List<List<String>> allLines, List<Integer> imgIndexs) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            Cell cell;
            int j;
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            if (i >= 1) {
                row.setHeight((short)1500);
                for (j = 0; j < line.size(); ++j) {
                    if (imgIndexs != null && imgIndexs.contains(j)) {
                        try {
                            String imgStr = line.get(j);
                            if (imgStr != null && imgStr != "") {
                                String[] imgUrlArray = imgStr.split("\uff0c");
                                short imgColIndex = (short)j;
                                for (String imgUrl : imgUrlArray) {
                                    if (imgStr == null || imgStr.trim().equals("")) continue;
                                    BufferedImage bufferImg = null;
                                    ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                                    URL url = new URL(imgUrl);
                                    bufferImg = ImageIO.read(url);
                                    int width = bufferImg.getWidth();
                                    int height = bufferImg.getHeight();
                                    height = (int)Math.round((double)(height * 390) * 1.0 / (double)width);
                                    row.setHeight((short)(height / 4 * 20));
                                    sheet.setColumnWidth((int)imgColIndex, 7680);
                                    ImageIO.write((RenderedImage)bufferImg, "jpg", byteArrayOut);
                                    HSSFClientAnchor anchor = new HSSFClientAnchor(255, 15, 900, 240, imgColIndex, i, imgColIndex, i);
                                    patriarch.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), 5));
                                    imgColIndex = (short)(imgColIndex + 1);
                                }
                                continue;
                            }
                            Cell cell2 = row.createCell(j);
                            cell2.setCellStyle((CellStyle)style);
                            cell2.setCellValue((RichTextString)new HSSFRichTextString(line.get(j)));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    cell = row.createCell(j);
                    cell.setCellStyle((CellStyle)style);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(line.get(j)));
                }
                continue;
            }
            for (j = 0; j < line.size(); ++j) {
                cell = row.createCell(j);
                cell.setCellStyle((CellStyle)style);
                cell.setCellValue((RichTextString)new HSSFRichTextString(line.get(j)));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeExcel(List<String> fileLists, String path, String fileName) {
        String excelFileName;
        File excelFile;
        Throwable throwable;
        XSSFWorkbook newExcelWorkBook = new XSSFWorkbook();
        for (String excelName : fileLists) {
            try {
                FileInputStream in = new FileInputStream(excelName);
                throwable = null;
                try {
                    XSSFWorkbook tmpWorkBook = new XSSFWorkbook((InputStream)in);
                    int len = tmpWorkBook.getNumberOfSheets();
                    if (len <= 1) {
                        XSSFSheet tmpSheet = tmpWorkBook.getSheetAt(0);
                        XSSFSheet newExcelSheet = newExcelWorkBook.createSheet(tmpSheet.getSheetName());
                        ExcelUtil.copyExcelSheet(newExcelWorkBook, tmpSheet, newExcelSheet);
                    } else {
                        for (int i = 0; i < len; ++i) {
                            XSSFSheet tmpSheet = tmpWorkBook.getSheetAt(i);
                            XSSFSheet newExcelSheet = newExcelWorkBook.createSheet(tmpSheet.getSheetName());
                            ExcelUtil.copyExcelSheet(newExcelWorkBook, tmpSheet, newExcelSheet);
                        }
                    }
                    tmpWorkBook.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            fileName = fileName + ".xlsx";
        }
        if ((excelFile = new File(excelFileName = path + File.separator + fileName)).exists()) {
            excelFile.delete();
        }
        try {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(excelFileName);){
                newExcelWorkBook.write((OutputStream)fos);
                fos.flush();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                newExcelWorkBook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("excel\u6587\u4ef6\u5408\u5e76\u6210\u529f\uff0c\u5408\u5e76\u540e\u6587\u4ef6\u8def\u5f84\uff1a" + excelFileName);
    }

    public static void copyExcelSheet(XSSFWorkbook workbook, XSSFSheet tmpSheet, XSSFSheet newExcelSheet) {
        ExcelUtil.mergeSheetAllRegion(tmpSheet, newExcelSheet);
        int len = tmpSheet.getRow(tmpSheet.getFirstRowNum()).getLastCellNum();
        for (int i = 0; i < len; ++i) {
            newExcelSheet.setColumnWidth(i, tmpSheet.getColumnWidth(i));
        }
        for (XSSFRow tmpRow : tmpSheet) {
            XSSFRow newExcelRow = newExcelSheet.createRow(tmpRow.getRowNum());
            ExcelUtil.copyExcelRow(workbook, tmpRow, newExcelRow);
        }
    }

    private static void mergeSheetAllRegion(XSSFSheet tmpSheet, XSSFSheet newExcelSheet) {
        int num = tmpSheet.getNumMergedRegions();
        CellRangeAddress cellRange = null;
        for (int i = 0; i < num; ++i) {
            cellRange = tmpSheet.getMergedRegion(i);
            newExcelSheet.addMergedRegion(cellRange);
        }
    }

    public static void copyExcelRow(XSSFWorkbook workbook, XSSFRow tmpRow, XSSFRow newExcelRow) {
        newExcelRow.setHeight(tmpRow.getHeight());
        Iterator it = tmpRow.cellIterator();
        while (it.hasNext()) {
            XSSFCell tmpCell = (XSSFCell)it.next();
            XSSFCell newExcelCell = newExcelRow.createCell(tmpCell.getColumnIndex());
            ExcelUtil.copyExcelCell(workbook, tmpCell, newExcelCell);
        }
    }

    public static void copyExcelCell(XSSFWorkbook workbook, XSSFCell tmpCell, XSSFCell newExcelCell) {
        XSSFCellStyle newExcelStyle = workbook.createCellStyle();
        newExcelStyle.cloneStyleFrom((CellStyle)tmpCell.getCellStyle());
        newExcelCell.setCellStyle((CellStyle)newExcelStyle);
        if (tmpCell.getCellComment() != null) {
            newExcelCell.setCellComment((Comment)tmpCell.getCellComment());
        }
        CellType tmpCellType = tmpCell.getCellTypeEnum();
        newExcelCell.setCellType(tmpCellType);
        if (tmpCellType == CellType.NUMERIC) {
            if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)tmpCell)) {
                newExcelCell.setCellValue(tmpCell.getDateCellValue());
            } else {
                newExcelCell.setCellValue(tmpCell.getNumericCellValue());
            }
        } else if (tmpCellType == CellType.STRING) {
            newExcelCell.setCellValue((RichTextString)tmpCell.getRichStringCellValue());
        } else if (tmpCellType != CellType.BLANK) {
            if (tmpCellType == CellType.BOOLEAN) {
                newExcelCell.setCellValue(tmpCell.getBooleanCellValue());
            } else if (tmpCellType == CellType.ERROR) {
                newExcelCell.setCellErrorValue(tmpCell.getErrorCellValue());
            } else if (tmpCellType == CellType.FORMULA) {
                newExcelCell.setCellFormula(tmpCell.getCellFormula());
            }
        }
    }

    public static class Excel {
        private Sheet sheet;
        private Workbook wb;

        public Excel isOldVersion(boolean flag) {
            this.wb = flag ? new HSSFWorkbook() : new XSSFWorkbook();
            return this;
        }

        public Excel name(String sheetName) {
            this.sheet = this.wb.createSheet(sheetName);
            return this;
        }

        public Excel data(List<List<String>> allLines) {
            CellStyle style = this.wb.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setWrapText(true);
            for (int i = 0; i < allLines.size(); ++i) {
                Row row = this.sheet.createRow(i);
                List<String> line = allLines.get(i);
                for (int j = 0; j < line.size(); ++j) {
                    Cell cell = row.createCell(j);
                    cell.setCellType(1);
                    cell.setCellValue(line.get(j));
                }
            }
            return this;
        }

        public Excel columnWidth(int index, int width) {
            this.sheet.setColumnWidth(index, width);
            return this;
        }

        public byte[] toByteArray() {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.wb.write((OutputStream)os);
                os.flush();
                os.close();
            }
            catch (IOException e) {
                log.warn("", (Throwable)e);
                throw new RuntimeException("Write Excel File Error");
            }
            return os.toByteArray();
        }
    }
}

