/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.redis.script;

import com.thebeastshop.kit.redis.script.RedisNamedScript;
import com.thebeastshop.kit.redis.script.RedisScriptManager;
import com.thebeastshop.kit.redis.script.RedisScriptParserError;
import com.thebeastshop.kit.redis.script.RedisScriptSource;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisScriptParser {
    private static final Logger log = LoggerFactory.getLogger(RedisScriptParser.class);
    private RedisScriptSource source;
    private String sourceText;
    private int readIndex = -1;
    private int lineNumber = 1;
    private RedisScriptManager redisScriptManager;
    private boolean isModule = false;
    private String moduleName;
    private static final char SINGLE_QUOTATION = '\'';
    private static final char DOUBLE_QUOTATION = '\"';
    private static final String KW_INCLUDE = "include";
    private static final String KW_MODULE = "module";
    private static final String END_OF_MULTI_LINE_COMMENT = "--]]";
    private Map<String, RedisNamedScript> includedCached = new HashMap<String, RedisNamedScript>();
    private StringBuilder builder = new StringBuilder();

    public RedisScriptParser(RedisScriptManager redisScriptManager, RedisScriptSource source) {
        this.redisScriptManager = redisScriptManager;
        this.source = source;
        this.sourceText = source.getSource();
    }

    private void error(String message) {
        throw new RedisScriptParserError("\n\n    An Error occurred during parsing a redis script [\"" + this.source.getUrl().getPath() + "\" : line " + this.lineNumber + "]:\n        " + message + "\n");
    }

    private char nextChar() {
        ++this.readIndex;
        return this.currentChar();
    }

    private void record(char ch) {
        this.builder.append(ch);
    }

    private void record(String str) {
        this.builder.append(str);
    }

    private boolean match(char expect) {
        char ch = this.currentChar();
        return ch == expect;
    }

    private void skip(int dist) {
        this.readIndex += dist;
    }

    private boolean matchNL() {
        boolean ret;
        char ch = this.currentChar();
        boolean bl = ret = ch == '\n' || ch == '\r' && this.look(1) == '\n';
        if (ret) {
            ++this.lineNumber;
        }
        return ret;
    }

    private char currentChar() {
        if (this.readIndex >= this.sourceText.length()) {
            this.error("Index out of bounds reading source text!");
        }
        return this.sourceText.charAt(this.readIndex);
    }

    private char look(int dist) {
        if (this.readIndex + dist >= this.sourceText.length()) {
            this.error("Index out of bounds reading source text!");
        }
        return this.sourceText.charAt(this.readIndex + dist);
    }

    private int lookWord(String word) {
        int i;
        for (i = 0; i < word.length() && this.hasNext(); ++i) {
            char chw;
            char chs = this.look(i);
            if (chs == (chw = word.charAt(i))) continue;
            return -1;
        }
        return i;
    }

    private String parseQuotationString(char quotation) {
        StringBuilder strbuilder = new StringBuilder();
        if (this.match(quotation)) {
            do {
                char ch = this.nextChar();
                if (this.match(quotation)) break;
                strbuilder.append(ch);
            } while (this.hasNext());
        }
        return strbuilder.toString();
    }

    private String parseString() {
        if (this.match('\'')) {
            return this.parseQuotationString('\'');
        }
        if (this.match('\"')) {
            return this.parseQuotationString('\"');
        }
        return null;
    }

    private boolean hasNext() {
        return this.readIndex + 1 < this.sourceText.length();
    }

    private boolean skipWhiteSpace() {
        boolean hasNL = false;
        boolean hasSpace = false;
        boolean hasTab = false;
        boolean endOfFile = false;
        char ch = this.currentChar();
        if (this.hasNext() && (ch == '\n' || ch == '\r' || ch == ' ' || ch == '\t')) {
            if (this.matchNL()) {
                hasNL = true;
            } else if (this.match(' ')) {
                hasSpace = true;
            } else if (this.match('\t')) {
                hasTab = true;
            }
            if (!this.hasNext()) {
                endOfFile = true;
            }
            do {
                ch = this.nextChar();
                if (this.matchNL()) {
                    hasNL = true;
                } else if (this.match(' ')) {
                    hasSpace = true;
                } else if (this.match('\t')) {
                    hasTab = true;
                }
                if (this.hasNext()) continue;
                endOfFile = true;
            } while (this.hasNext() && (ch == '\n' || ch == '\r' || ch == ' ' || ch == '\t'));
            if (this.builder.length() > 0) {
                char lastCh = this.builder.charAt(this.builder.length() - 1);
                if (hasNL && !endOfFile && lastCh != '\n') {
                    this.record('\n');
                }
                if (hasSpace && !endOfFile && lastCh != ' ' && lastCh != '\n' && lastCh != '\t') {
                    this.record(' ');
                }
                if (hasTab && !endOfFile && lastCh != '\t' && lastCh != ' ') {
                    this.record("  ");
                }
            }
        }
        return hasNL;
    }

    private void skipComments() {
        boolean isSingleLine = this.skipSingleLineComments();
        if (!isSingleLine) {
            this.skipMultiLineComments();
        }
    }

    private boolean skipSingleLineComments() {
        char ch = this.currentChar();
        if (ch == '-' && this.hasNext() && this.look(1) == '-') {
            do {
                if ((ch = this.nextChar()) != '[' || !this.hasNext() || this.look(1) != '[') continue;
                this.nextChar();
                return false;
            } while (this.hasNext() && (this.look(1) != '\n' || this.look(1) == '\r' && this.look(2) == '\n'));
        }
        return true;
    }

    private void skipMultiLineComments() {
        do {
            this.matchNL();
            int i = this.lookWord(END_OF_MULTI_LINE_COMMENT);
            if (i > 0) {
                this.skip(i - 1);
                return;
            }
            this.nextChar();
        } while (this.hasNext());
    }

    private boolean isNeedInclude(String path) {
        return !this.includedCached.containsKey(path);
    }

    public void include(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return;
        }
        log.info("path=" + path);
        String folder = "lua";
        String newPath = folder + '/' + path;
        URL url = Thread.currentThread().getContextClassLoader().getResource(newPath);
        if (!this.isNeedInclude(url.getPath())) {
            return;
        }
        RedisNamedScript script = null;
        try {
            script = this.redisScriptManager.loadScript(url);
        }
        catch (Throwable th) {
            this.error("include \"" + path + "\"\n                 ^\n        File \"" + url.getPath() + "\" cannot be found!\n\n Cause: " + th);
        }
        if (script == null) {
            this.error("Can not include script [" + path + "]!");
        }
        if (!script.isModule().booleanValue()) {
            this.error("include \"" + path + "\"\n                 ^\n        Script \"" + script.getName() + "\" is not a module, therefore it cannot be included!");
        }
        String scriptText = script.getScript();
        this.record(scriptText);
        this.includedCached.put(url.getPath(), script);
        this.includedCached.putAll(script.getIncludedModules());
    }

    public RedisNamedScript parse() throws IOException {
        log.info(" [Redis] \u5f00\u59cb\u89e3\u6790\u811a\u672c[\"" + this.source.getName() + "\"]!");
        while (this.hasNext()) {
            int i;
            this.nextChar();
            boolean hasNL = this.skipWhiteSpace();
            boolean canReadKeyword = hasNL || this.lineNumber == 1;
            char ch = this.currentChar();
            if (ch == 'i' && canReadKeyword) {
                i = this.lookWord(KW_INCLUDE);
                if (i > 0) {
                    this.skip(i);
                    this.skipWhiteSpace();
                    String path = this.parseString();
                    this.include(path);
                    continue;
                }
                this.record(ch);
                continue;
            }
            if (ch == 'm' && canReadKeyword) {
                i = this.lookWord(KW_MODULE);
                if (i > 0) {
                    this.skip(i);
                    this.skipWhiteSpace();
                    this.moduleName = this.parseString();
                    this.isModule = true;
                    continue;
                }
                this.record(ch);
                continue;
            }
            if (ch == '-' && this.hasNext() && this.look(1) == '-') {
                this.skipComments();
                continue;
            }
            this.record(ch);
        }
        log.info(" [Redis] \u89e3\u6790\u811a\u672c[\"" + this.source.getName() + "\"]\u5b8c\u6210!");
        return this.getScript();
    }

    private RedisNamedScript getScript() {
        RedisNamedScript script = new RedisNamedScript(this.source.getName(), this.source, this.builder.toString(), this.isModule, this.moduleName, this.includedCached);
        return script;
    }
}

