package com.thebeastshop.common.zk;

import com.alibaba.fastjson.JSON;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;

import java.lang.reflect.ParameterizedType;

/**
 * 数据监听器
 * @author Bryan.Zhang
 * @Date 2019-01-03
 */
public abstract class ZkListener<T> implements NodeCacheListener {

    private NodeCache cache;

    @Override
    public void nodeChanged() throws Exception {
        byte[] res = cache.getCurrentData().getData();
        String data = new String(res);
        dataChanged(JSON.parseObject(data,getClazz()));
    }

    private Class<T> getClazz(){
        return (Class <T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public abstract void dataChanged(T data);

    public NodeCache getCache() {
        return cache;
    }

    public void setCache(NodeCache cache) {
        this.cache = cache;
    }
}
