/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.flowable.springboot;

import com.thebeastshop.kit.flowable.FlowableBPMScanner;
import com.thebeastshop.kit.flowable.FlowableEngine;
import com.thebeastshop.kit.flowable.FlowableEngineFactoryBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class FlowableAutoConfiguration {
    public static final String FLOWABLE_JDBC_URL_KEY = "flowable.jdbc.url";
    public static final String FLOWABLE_JDBC_DRIVER_KEY = "flowable.jdbc.driver";
    public static final String FLOWABLE_JDBC_USERNAME_KEY = "flowable.jdbc.username";
    public static final String FLOWABLE_JDBC_PASSWORD_KEY = "flowable.jdbc.password";
    public static final String FLOWABLE_SCAN_LOCATION = "flowable.scan.location";

    @Bean
    @ConditionalOnProperty(prefix="flowable.jdbc", name={"url", "driver", "username", "password"})
    public FlowableEngineFactoryBean flowableEngineFactoryBean(Environment environment) {
        String flowableJdbcUrl = environment.getProperty(FLOWABLE_JDBC_URL_KEY);
        String flowableJdbcDriver = environment.getProperty(FLOWABLE_JDBC_DRIVER_KEY);
        String flowableJdbcUsername = environment.getProperty(FLOWABLE_JDBC_USERNAME_KEY);
        String flowableJdbcPassword = environment.getProperty(FLOWABLE_JDBC_PASSWORD_KEY);
        return new FlowableEngineFactoryBean(flowableJdbcUrl, flowableJdbcDriver, flowableJdbcUsername, flowableJdbcPassword);
    }

    @Bean
    public FlowableBPMScanner flowableEngine(Environment environment, FlowableEngine flowableEngine) {
        FlowableBPMScanner flowableBPMScanner = new FlowableBPMScanner();
        flowableBPMScanner.setFlowableEngine(flowableEngine);
        String flowableScanLocation = environment.getProperty(FLOWABLE_SCAN_LOCATION);
        if (StringUtils.isNotBlank((CharSequence)flowableScanLocation)) {
            flowableBPMScanner.setLocation(flowableScanLocation);
        }
        return flowableBPMScanner;
    }
}

