/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.flowable;

import com.thebeastshop.kit.flowable.Exceptions.FlowableException;
import com.thebeastshop.kit.flowable.bean.FlowGroup;
import com.thebeastshop.kit.flowable.bean.FlowUser;
import com.thebeastshop.kit.flowable.bean.NextTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableEngine {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProcessEngine processEngine;

    public FlowableEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void deploy(String resource, String deployName, String category) {
        try {
            RepositoryService repositoryService = this.processEngine.getRepositoryService();
            Deployment deployment = repositoryService.createDeployment().addClasspathResource(resource).name(deployName).category(category).deploy();
            ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
            this.log.info("[FLOWABLE]\u6d41\u7a0b\u8d44\u6e90[{}]\u5df2\u7ecf\u88ab\u6210\u529f\u90e8\u7f72! \u6d41\u7a0b\u540d\u79f0:[{}],\u6d41\u7a0bID:[{}],\u6d41\u7a0bKEY:[{}]", new Object[]{resource, processDefinition.getName(), processDefinition.getId(), processDefinition.getKey()});
        }
        catch (Throwable t) {
            String errMsg = "flowable process deploy error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<NextTask> startProcess(String processId, String bizKey, String applyUser) {
        try {
            IdentityService identityService = this.processEngine.getIdentityService();
            identityService.setAuthenticatedUserId(applyUser);
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(processId, bizKey);
            this.log.info("[FLOWABLE]\u6d41\u7a0b\u5b9e\u4f8bID = {}", (Object)processInstance.getId());
            this.log.info("[FLOWABLE]\u6b63\u5728\u6d3b\u52a8\u7684\u6d41\u7a0b\u8282\u70b9ID = {}", (Object)processInstance.getActivityId());
            this.log.info("[FLOWABLE]\u6d41\u7a0b\u5b9a\u4e49ID = {}", (Object)processInstance.getProcessDefinitionId());
            this.log.info("[FLOWABLE]\u90e8\u7f72ID = {}", (Object)processInstance.getDeploymentId());
            this.log.info("[FLOWABLE]\u4e1a\u52a1KEY = {}", (Object)processInstance.getBusinessKey());
            return this.queryActiveTask(processInstance.getId());
        }
        catch (Throwable t) {
            String errMsg = "flowable process start error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public void completeTask(Task task, Map<String, Object> vars) {
        try {
            TaskService taskService = this.processEngine.getTaskService();
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            this.log.info("[FLOWABLE]\u4efb\u52a1\u540d\u79f0 = {}", (Object)task.getName());
            this.log.info("[FLOWABLE]\u6d41\u7a0b\u5b9e\u4f8bID = {}", (Object)processInstance.getId());
            this.log.info("[FLOWABLE]\u6b63\u5728\u6d3b\u52a8\u7684\u6d41\u7a0b\u8282\u70b9ID = {}", (Object)processInstance.getActivityId());
            this.log.info("[FLOWABLE]\u6d41\u7a0b\u5b9a\u4e49ID = {}", (Object)processInstance.getProcessDefinitionId());
            if (vars == null || MapUtils.isEmpty(vars)) {
                taskService.complete(task.getId());
            } else {
                taskService.complete(task.getId(), vars);
            }
        }
        catch (Throwable t) {
            String errMsg = "flowable task complete error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public void completeTask(String taskId, Map<String, Object> vars) {
        TaskService taskService = this.processEngine.getTaskService();
        Task task = (Task)((TaskQuery)taskService.createTaskQuery().taskId(taskId)).singleResult();
        this.completeTask(task, vars);
    }

    public void completeTask(String taskId) {
        this.completeTask(taskId, new HashMap<String, Object>());
    }

    public List<NextTask> completeTask(String processInstanceId, String assignment, Map<String, Object> vars) {
        TaskService taskService = this.processEngine.getTaskService();
        Task task = (Task)((TaskQuery)((TaskQuery)taskService.createTaskQuery().processInstanceId(processInstanceId)).taskAssignee(assignment)).singleResult();
        this.completeTask(task, vars);
        return this.queryActiveTask(processInstanceId);
    }

    public List<NextTask> completeTask(String processInstanceId, String assignment) {
        return this.completeTask(processInstanceId, assignment, new HashMap<String, Object>());
    }

    public void terminateProcess(String processInstanceId, String terminateReason) {
        try {
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            runtimeService.deleteProcessInstance(processInstanceId, terminateReason);
        }
        catch (Throwable t) {
            String errMsg = "flowable process terminate error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<Task> queryTask(String assignment, String processInstanceId, int firstResult, int maxResults) {
        try {
            TaskService taskService = this.processEngine.getTaskService();
            List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)taskService.createTaskQuery().taskAssignee(assignment)).processInstanceId(processInstanceId)).orderByTaskCreateTime()).desc()).listPage(firstResult, maxResults);
            return taskList;
        }
        catch (Throwable t) {
            String errMsg = "flowable task query error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<Task> queryTask(String assignment, int firstResult, int maxResults) {
        try {
            TaskService taskService = this.processEngine.getTaskService();
            List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)taskService.createTaskQuery().taskAssignee(assignment)).orderByTaskCreateTime()).desc()).listPage(firstResult, maxResults);
            return taskList;
        }
        catch (Throwable t) {
            String errMsg = "flowable task query error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<NextTask> queryActiveTask(String processInstanceId) {
        try {
            TaskService taskService = this.processEngine.getTaskService();
            List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)taskService.createTaskQuery().processInstanceId(processInstanceId)).active().orderByTaskCreateTime()).desc()).list();
            return this.transform(taskList);
        }
        catch (Throwable t) {
            String errMsg = "flowable task query error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<ProcessInstance> queryActiveProcessInstance(int firstResult, int maxResults) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        List processInstanceList = ((ProcessInstanceQuery)runtimeService.createProcessInstanceQuery().active().orderByStartTime().desc()).listPage(firstResult, maxResults);
        return processInstanceList;
    }

    public List<ProcessInstance> queryAllProcessInstance(int firstResult, int maxResults) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        List processInstanceList = ((ProcessInstanceQuery)runtimeService.createProcessInstanceQuery().orderByStartTime().desc()).listPage(firstResult, maxResults);
        return processInstanceList;
    }

    public ProcessInstance queryProcessInstanceByBizKey(String bizKey) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        ProcessInstance processInstance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(bizKey).singleResult();
        return processInstance;
    }

    public List<HistoricActivityInstance> queryHisAct(String processInstanceId) {
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        return list;
    }

    public void createUser(FlowUser flowUser) {
        try {
            IdentityService identityService = this.processEngine.getIdentityService();
            User tuser = identityService.newUser(flowUser.getUserId());
            identityService.saveUser(tuser);
            UserEntityImpl user = new UserEntityImpl();
            user.setId(flowUser.getUserId());
            user.setEmail(flowUser.getEmail());
            user.setFirstName(flowUser.getFirstName());
            user.setLastName(flowUser.getLastName());
            identityService.saveUser((User)user);
            user.setPassword(flowUser.getPassword());
            identityService.updateUserPassword((User)user);
        }
        catch (Throwable t) {
            String errMsg = "flowable user create error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public void createGroup(FlowGroup flowGroup) {
        try {
            IdentityService identityService = this.processEngine.getIdentityService();
            Group tgroup = identityService.newGroup(flowGroup.getGroupId());
            identityService.saveGroup(tgroup);
            GroupEntityImpl group = new GroupEntityImpl();
            group.setId(flowGroup.getGroupId());
            group.setName(flowGroup.getGroupName());
            identityService.saveGroup((Group)group);
        }
        catch (Throwable t) {
            String errMsg = "flowable group create error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public void createMembership(String userId, String groupId) {
        try {
            this.processEngine.getIdentityService().createMembership(userId, groupId);
        }
        catch (Throwable t) {
            String errMsg = "flowable merbership create error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public FlowUser queryUser(String userId) {
        try {
            IdentityService identityService = this.processEngine.getIdentityService();
            User user = (User)((UserQuery)identityService.createUserQuery().userId(userId)).singleResult();
            if (user == null) {
                return null;
            }
            FlowUser flowUser = this.transformUser(user);
            List groupList = identityService.createGroupQuery().groupMember(flowUser.getUserId()).list();
            ArrayList<FlowGroup> flowGroupList = new ArrayList<FlowGroup>();
            groupList.forEach(group -> flowGroupList.add(new FlowGroup(group.getId(), group.getName())));
            flowUser.setGroupList(flowGroupList);
            return flowUser;
        }
        catch (Throwable t) {
            String errMsg = "flowable query user error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public FlowGroup queryGroup(String groupId) {
        try {
            Group group = (Group)this.processEngine.getIdentityService().createGroupQuery().groupId(groupId).singleResult();
            if (group == null) {
                return null;
            }
            FlowGroup flowGroup = new FlowGroup(group.getId(), group.getName());
            return flowGroup;
        }
        catch (Throwable t) {
            String errMsg = "flowable query group error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    public List<FlowUser> queryGroupUser(String groupId) {
        try {
            IdentityService identityService = this.processEngine.getIdentityService();
            List userList = ((UserQuery)identityService.createUserQuery().memberOfGroup(groupId)).list();
            ArrayList<FlowUser> flowUserList = new ArrayList<FlowUser>();
            userList.forEach(user -> flowUserList.add(this.transformUser((User)user)));
            return flowUserList;
        }
        catch (Throwable t) {
            String errMsg = "flowable query group error";
            this.log.error(errMsg, t);
            throw new FlowableException(errMsg, t);
        }
    }

    private List<NextTask> transform(List<Task> taskList) {
        ArrayList<NextTask> nextTaskList = new ArrayList<NextTask>();
        taskList.forEach(task -> {
            NextTask nextTask = new NextTask();
            nextTask.setTaskId(task.getId());
            nextTask.setTaskName(task.getName());
            nextTask.setProcessInstanceId(task.getProcessInstanceId());
            nextTask.setAssignee(task.getAssignee());
            nextTask.setTaskDefinationId(task.getTaskDefinitionId());
            nextTask.setTaskDefinationKey(task.getTaskDefinitionKey());
            nextTaskList.add(nextTask);
        });
        return nextTaskList;
    }

    private FlowUser transformUser(User user) {
        FlowUser flowUser = new FlowUser();
        flowUser.setUserId(user.getId());
        flowUser.setFirstName(user.getFirstName());
        flowUser.setLastName(user.getLastName());
        flowUser.setEmail(user.getEmail());
        flowUser.setPassword(user.getPassword());
        return flowUser;
    }
}

