/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.flowable;

import com.thebeastshop.common.utils.FileUtil;
import com.thebeastshop.common.utils.MD5Util;
import com.thebeastshop.kit.flowable.FlowableEngine;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class FlowableBPMScanner
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DIGEST_PATH_LINUX = "/data/appdatas/flowable/";
    private static final String DIGEST_PATH_WIN = "C:/data/appdatas/flowable/";
    private static final String DIGEST_FILE = "bpm_digest.txt";
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private String location = "classpath:flowable/*.xml";
    private FlowableEngine flowableEngine;

    public void afterPropertiesSet() throws Exception {
        this.log.info("[FLOWABLE]\u5f00\u59cb\u626b\u63cf[{}]\u7684\u53d8\u52a8\u6d41\u7a0b\u8d44\u6e90\u6587\u4ef6", (Object)this.location);
        if (StringUtils.isBlank((CharSequence)this.location)) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(this.location);
        Map<String, String> digestMap = this.getDigest();
        boolean isChange = false;
        for (Resource resource : resources) {
            String content = IOUtils.toString((URI)resource.getURI(), (String)"UTF-8");
            String md5Str = MD5Util.makeMD5((String)content);
            if (!StringUtils.isBlank((CharSequence)digestMap.get(resource.getFilename())) && md5Str.equals(digestMap.get(resource.getFilename()))) continue;
            this.log.info("[FLOWABLE]\u5f00\u59cb\u90e8\u7f72\u6d41\u7a0b\u8d44\u6e90\u6587\u4ef6{}", (Object)resource.getFilename());
            digestMap.put(resource.getFilename(), md5Str);
            this.flowableEngine.deploy(this.getProjectPath(resource.getFile().getPath()), resource.getFilename(), this.getAppName());
            isChange = true;
        }
        if (isChange) {
            this.log.info("[FLOWABLE]\u5199\u5165\u6458\u8981\u6587\u4ef6");
            String dir = this.getFileDir();
            if (!FileUtil.exists((String)dir).booleanValue()) {
                FileUtil.createDirectory((String)dir);
            }
            ArrayList writeList = new ArrayList();
            digestMap.forEach((k, v) -> writeList.add(k + "," + v));
            FileUtil.writeList2File(writeList, (String)(dir + DIGEST_FILE));
        } else {
            this.log.info("[FLOWABLE]\u6ca1\u6709\u626b\u63cf\u5230\u53d1\u751f\u6539\u53d8\u7684\u8d44\u6e90\u6587\u4ef6");
        }
    }

    private Map<String, String> getDigest() {
        try {
            List digestList = FileUtil.readFile2List((String)(this.getFileDir() + DIGEST_FILE));
            HashMap<String, String> map = new HashMap<String, String>();
            digestList.forEach(s -> {
                String[] array = s.split(",");
                map.put(array[0], array[1]);
            });
            return map;
        }
        catch (Throwable t) {
            return new HashMap<String, String>();
        }
    }

    private String getFileDir() {
        String digestPath = OS.equals("win") ? DIGEST_PATH_WIN : DIGEST_PATH_LINUX;
        return digestPath;
    }

    private String getAppName() {
        String str = System.getProperty("user.dir");
        String appName = str.substring(str.lastIndexOf(File.separator) + 1);
        return appName;
    }

    private String getProjectPath(String filePath) {
        String word = "classes/";
        if (filePath.indexOf(word) == -1) {
            return filePath;
        }
        return filePath.substring(filePath.lastIndexOf(word) + word.length());
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public FlowableEngine getFlowableEngine() {
        return this.flowableEngine;
    }

    public void setFlowableEngine(FlowableEngine flowableEngine) {
        this.flowableEngine = flowableEngine;
    }
}

