package com.thebeastshop.kit.actuator.aop;

import com.thebeastshop.kit.actuator.anno.BeastMetrics;
import com.thebeastshop.kit.actuator.anno.MetricsType;
import com.thebeastshop.kit.prop.PropConfig;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import javax.annotation.Resource;
import java.lang.reflect.Method;

@Aspect
public class MetricsAspect {

    private final String COUNT_KEY = "bm_count";

    private final String COUNT_E_KEY = "bm_count_e";

    private final String TIME_KEY = "bm_time";

    @Resource
    private MeterRegistry registry;

    @Pointcut("@within(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut1(){}

    @Pointcut("@annotation(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut2(){}

    @Around("cut1()")
    public Object around1(ProceedingJoinPoint jp) throws Throwable{
        Class<?> clazz = jp.getTarget().getClass();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        BeastMetrics beastMetrics = clazz.getAnnotation(BeastMetrics.class);
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();

        String methodTag = clazz.getSimpleName() + "#" + method.getName();

        try{
            switch (metricsType){
                case INVOKE_COUNT:
                    Object object = jp.proceed();

                    Counter.builder(COUNT_KEY)
                            .tag("method", methodTag)
                            .description(description).register(registry).increment();
                    return object;
                case INVOKE_TIME:
                    Timer timer = Timer.builder(TIME_KEY)
                            .tag("method", methodTag)
                            .description(description).register(registry);
                    return timer.recordCallable(() -> {
                        try {
                            return jp.proceed();
                        } catch (Throwable e) {
                            throw new Exception(e);
                        }
                    });
                default:
                    return jp.proceed();
            }
        }catch (Throwable t){
            Counter.builder(COUNT_E_KEY)
                    .tag("method", methodTag)
                    .tag("message", t.getMessage())
                    .description(description).register(registry).increment();
            throw t;
        }

    }

    @Around("cut2()")
    public Object around2(ProceedingJoinPoint jp) throws Throwable{
        Class<?> clazz = jp.getTarget().getClass();
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();

        String methodTag = clazz.getSimpleName() + "#" + method.getName();

        BeastMetrics beastMetrics = method.getAnnotation(BeastMetrics.class);
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();

        try{
            switch (metricsType){
                case INVOKE_COUNT:
                    Object object = jp.proceed();
                    Counter.builder(COUNT_KEY)
                            .tag("method", methodTag)
                            .description(description).register(registry).increment();
                    return object;
                case INVOKE_TIME:
                    Timer timer = Timer.builder(TIME_KEY)
                            .tag("method", methodTag)
                            .description(description).register(registry);
                    return timer.recordCallable(() -> {
                        try {
                            return jp.proceed();
                        } catch (Throwable e) {
                            throw new Exception(e);
                        }
                    });
                default:
                    return jp.proceed();
            }
        }catch (Throwable t){
            Counter.builder(COUNT_E_KEY)
                    .tag("method", methodTag)
                    .tag("message", t.getMessage())
                    .description(description).register(registry).increment();
            throw t;
        }
    }
}
