package com.thebeastshop.kit.actuator;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;

import javax.annotation.Resource;
import java.util.function.Supplier;

public class MetricsEngine {

    private final String KEY_PREFIX = "bm_";

    @Resource
    private MeterRegistry registry;

    public void countOne(String key, String description){
        this.count(key, description, 1.0);
    }

    public void count(String key, String description, double value){
        Counter.builder(KEY_PREFIX + key).description(description).register(registry).increment(value);
    }

    public void gauge(String key, String description, double value){
        Gauge.builder(KEY_PREFIX + key, () -> value).description(description).register(registry);
    }

    public <T> T time(String key, String description, Supplier<T> supplier){
        Timer timer = Timer.builder(KEY_PREFIX + key).description(description).register(registry);
        return timer.record(supplier);
    }
}
