/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboHealthBizData {
    private static Logger log = LoggerFactory.getLogger(DubboHealthBizData.class);
    public static Set<LongTaskTimer.Sample> taskTimerSet = Sets.newConcurrentHashSet();
    private static MeterRegistry registry;

    public static void setRegistry(MeterRegistry registry) {
        DubboHealthBizData.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result timer(Invoker<?> invoker, Invocation invocation) {
        if (registry == null) {
            return invoker.invoke(invocation);
        }
        Result result = null;
        String methodName = invocation.getInvoker().getInterface().getName() + "." + invocation.getMethodName();
        Counter counter = registry.counter("dubbo_invoke", new String[]{"method", methodName});
        counter.increment();
        LongTaskTimer longTaskTimer = LongTaskTimer.builder((String)"dubbo_long_invoke").tag("method", methodName).register(registry);
        LongTaskTimer.Sample sample = longTaskTimer.start();
        taskTimerSet.add(sample);
        try {
            result = invoker.invoke(invocation);
        }
        finally {
            sample.stop();
            taskTimerSet.remove(sample);
        }
        return result;
    }
}

