package com.thebeastshop.kit.actuator.aop;

import com.thebeastshop.kit.actuator.anno.BeastMetrics;
import com.thebeastshop.kit.actuator.anno.MetricsType;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import javax.annotation.Resource;
import java.lang.reflect.Method;

@Aspect
public class MetricsAspect {

    private final String KEY_PREFIX = "bm-";

    @Resource
    private MeterRegistry registry;

    @Pointcut("@within(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut1(){}

    @Pointcut("@annotation(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut2(){}

    @Around("cut1()")
    public Object around1(ProceedingJoinPoint jp) throws Throwable{
        Class<?> clazz = jp.getTarget().getClass();
        BeastMetrics beastMetrics = clazz.getAnnotation(BeastMetrics.class);
        String key = beastMetrics.key();
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();
        switch (metricsType){
            case INVOKE_COUNT:
                Object object = jp.proceed();
                Counter.builder(KEY_PREFIX + key).description(description).register(registry).increment();
                return object;
            case INVOKE_TIME:
                Timer timer = Timer.builder(KEY_PREFIX + key).description(description).register(registry);
                return timer.recordCallable(() -> {
                    try {
                        return jp.proceed();
                    } catch (Throwable e) {
                        throw new Exception(e);
                    }
                });
            default:
                return jp.proceed();
        }
    }

    @Around("cut2()")
    public Object around2(ProceedingJoinPoint jp) throws Throwable{
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        BeastMetrics beastMetrics = method.getAnnotation(BeastMetrics.class);

        String key = beastMetrics.key();
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();
        switch (metricsType){
            case INVOKE_COUNT:
                Object object = jp.proceed();
                Counter.builder(KEY_PREFIX + key).description(description).register(registry).increment();
                return object;
            case INVOKE_TIME:
                Timer timer = Timer.builder(KEY_PREFIX + key).description(description).register(registry);
                return timer.recordCallable(() -> {
                    try {
                        return jp.proceed();
                    } catch (Throwable e) {
                        throw new Exception(e);
                    }
                });
            default:
                return jp.proceed();
        }
    }
}
