package com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean;

import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.LongTaskTimer;

import java.util.concurrent.TimeUnit;

public class DubboInvokeAlertCounterBinderBean {

    private final static int DUBBO_LONG_TASK_SECONDS_3_THRESHOLD = 3;

    private final static int DUBBO_LONG_TASK_SECONDS_5_THRESHOLD = 5;

    private final static int DUBBO_LONG_TASK_SECONDS_10_THRESHOLD = 10;

    public double getCount() {
        double count = 0;
        for (LongTaskTimer.Sample sample : DubboHealthBizData.taskTimerSet){
            if(sample.duration(TimeUnit.SECONDS) > DUBBO_LONG_TASK_SECONDS_5_THRESHOLD){
                count++;
            }
        }
        return count;
    }
}
