package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DubboHealthBizData {

    public static final int HEALTH_TIMEOUT_3_SECONDS = 3;

    public static final int HEALTH_TIMEOUT_5_SECONDS = 5;

    public static final int HEALTH_TIMEOUT_10_SECONDS = 10;

    private static MeterRegistry registry;

    public static void setRegistry(MeterRegistry registry) {
        DubboHealthBizData.registry = registry;
    }

    public static Result timer(Invoker<?> invoker, Invocation invocation) {
        if (registry == null) {
            return invoker.invoke(invocation);
        } else {
            AtomicReference<Result> result = new AtomicReference();
            String methodName = invocation.getInvoker().getInterface().getName()
                    + "." + invocation.getMethodName();
            Counter counter = registry
                    .counter("dubbo_invoke", "method", methodName);
            counter.increment();

            LongTaskTimer longTaskTimer10 = LongTaskTimer
                    .builder("dubbo_long_invoke_10")
                    .tag("method", methodName)
                    .register(registry);
            longTaskTimer10.duration(HEALTH_TIMEOUT_10_SECONDS, TimeUnit.SECONDS);

            LongTaskTimer longTaskTimer5 = LongTaskTimer
                    .builder("dubbo_long_invoke_5")
                    .tag("method", methodName)
                    .register(registry);
            longTaskTimer5.duration(HEALTH_TIMEOUT_5_SECONDS, TimeUnit.SECONDS);

            LongTaskTimer longTaskTimer3 = LongTaskTimer
                    .builder("dubbo_long_invoke_3")
                    .tag("method", methodName)
                    .register(registry);
            longTaskTimer3.duration(HEALTH_TIMEOUT_3_SECONDS, TimeUnit.SECONDS);

            longTaskTimer10.record(() -> longTaskTimer5.record(() -> longTaskTimer3.record(() -> result.set(invoker.invoke(invocation)))));

            return result.get();
        }
    }
}
