package com.thebeastshop.kit.actuator.config;

import com.google.common.collect.Lists;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.core.env.Environment;

import javax.swing.plaf.ActionMapUIResource;
import java.net.InetAddress;

public class ServiceDiscoveryInit implements InitializingBean {

    private ConsulDiscoveryProperties consulDiscoveryProperties;


    @Autowired
    private Environment environment;

    public ServiceDiscoveryInit(ConsulDiscoveryProperties consulDiscoveryProperties) {
        this.consulDiscoveryProperties = consulDiscoveryProperties;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        int port = environment.getProperty("server.port",Integer.class,-1);
        if (port == -1) {
            throw new RuntimeException("[beast-kit-actuator] please config the server.port first");
        }
        String appId = environment.getProperty("app.id", "");
        InetAddress inetAddress = InetAddress.getLocalHost();
        String instanceId = appId + "-" + inetAddress + "-" + StringUtils.trim(port + "");
        instanceId = instanceId.replaceAll("\\.", "-");
        consulDiscoveryProperties.setInstanceId(instanceId);
        String actuatorPort = ActuatorPortInit.actuatorPort + "";
        consulDiscoveryProperties.setHealthCheckUrl("http://" + inetAddress + ":" + actuatorPort);
        consulDiscoveryProperties.setTags(Lists.newArrayList());
    }
}
