/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.config;

import java.net.InetAddress;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.core.env.Environment;

public class ServiceDiscoveryInit
implements InitializingBean {
    private ConsulDiscoveryProperties consulDiscoveryProperties;
    @Autowired
    private Environment environment;

    public ServiceDiscoveryInit(ConsulDiscoveryProperties consulDiscoveryProperties) {
        this.consulDiscoveryProperties = consulDiscoveryProperties;
    }

    public void afterPropertiesSet() throws Exception {
        int port = (Integer)this.environment.getProperty("server.port", Integer.class, (Object)-1);
        if (port == -1) {
            throw new RuntimeException("[beast-kit-actuator] please config the server.port first");
        }
        String appId = this.environment.getProperty("app.id", "");
        InetAddress inetAddress = InetAddress.getLocalHost();
        String instanceId = appId + ":" + inetAddress.getHostAddress() + ":" + port;
        this.consulDiscoveryProperties.setInstanceId(instanceId);
    }
}

