package com.thebeastshop.kit.actuator.dubbo.autoconfigure;

import com.thebeastshop.kit.actuator.config.ActuatorPortInit;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerServiceImpl;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckConsumerFactoryBean;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckProviderInit;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboMetaBeanGetter;
import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;

@Configuration
@ConditionalOnBean(com.alibaba.dubbo.config.RegistryConfig.class)
public class DubboCheckerAutoConfiguration{

    @Bean
    public ActuatorPortInit actuatorPortInit(ManagementServerProperties managementServerProperties) {
        return new ActuatorPortInit(managementServerProperties);
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> metricsCommonTags(Environment environment, MeterRegistry registry) {
        String appId = environment.getProperty("app.id");
        if (StringUtils.isBlank(appId)) {
            throw new RuntimeException("[beast-kit-actuator] App ID does not exist!");
        }
        DubboHealthBizData.setRegistry(registry);

        return r -> {
            try {
                r.config().commonTags("application", appId);
                InetAddress inetAddress = InetAddress.getLocalHost();
                r.config().commonTags("hostname",inetAddress.getHostName());
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
        };
    }

    @Bean("dubboCheckerOriginalService")
    public DubboCheckerService dubboCheckerService() {
        return new DubboCheckerServiceImpl();
    }

    @Bean
    public DubboMetaBeanGetter dubboMetaBeanGetter() {
        return new DubboMetaBeanGetter();
    }

    @Bean
    public DubboCheckProviderInit checkProviderInit(DubboMetaBeanGetter dubboMetaBeanGetter,
                                                    DubboCheckerService dubboCheckerOriginalService) {
        return new DubboCheckProviderInit(dubboCheckerOriginalService);
    }

    @Bean("dubboCheckerService")
    public DubboCheckConsumerFactoryBean dubboCheckConsumerFactoryBean(DubboCheckProviderInit dubboCheckProviderInit,
                                                                       DubboMetaBeanGetter dubboMetaBeanGetter) {
        return new DubboCheckConsumerFactoryBean();
    }
}
