package com.thebeastshop.kit.actuator.dubbo.health;

import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class DubboInvokeHealthIndicator extends AbstractHealthIndicator {

    private Logger log = LoggerFactory.getLogger(DubboInvokeHealthIndicator.class);

    private final static String OK = "ok";

    @Resource(name = "dubboCheckerService")
    private DubboCheckerService dubboCheckerConsumerService;

    @Override
    protected void doHealthCheck(Health.Builder builder) {
        try{
            String result = dubboCheckerConsumerService.check();
            log.debug("[beast-kit-actuator] dubbo check: {}",result);
            if (result.equals(OK)) {
                builder.up();
            } else {
                builder.down();
            }
        } catch (Throwable t) {
            log.error("[beast-kit-actuator] 调用Dubbo检查接口失败，服务可能不可用! 由于: \n" + t.getMessage(),t);
            builder.down();
        }
    }
}
