package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DubboHealthBizData {

    public static final int HEALTH_TIMEOUT_MILLISECONDS = 5000;

    private static MeterRegistry registry;

    public static void setRegistry(MeterRegistry registry) {
        DubboHealthBizData.registry = registry;
    }

    public static Result timer(Invoker<?> invoker, Invocation invocation) {
        if (registry == null) {
            return invoker.invoke(invocation);
        } else {
            AtomicReference<Result> result = new AtomicReference();
            String methodName = invocation.getInvoker().getInterface().getName()
                    + "." + invocation.getMethodName();
            Counter counter = registry
                    .counter("dubbo_invoke", "method", methodName);
            counter.increment();
            LongTaskTimer longTaskTimer = LongTaskTimer
                    .builder("dubbo_long_invoke")
                    .tag("method", methodName)
                    .register(registry);

            longTaskTimer.duration(HEALTH_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
            longTaskTimer.record(() -> {
                result.set(invoker.invoke(invocation));
            });

            return result.get();
        }
    }
}
