/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.endpoint.metadata;

import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.spring.ServiceBean;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public abstract class AbstractDubboMetadata
implements ApplicationContextAware,
EnvironmentAware {
    protected ApplicationContext applicationContext;
    protected ConfigurableEnvironment environment;

    private static boolean isSimpleType(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) || type == String.class || type == BigDecimal.class || type == BigInteger.class || type == Date.class || type == URL.class || type == Class.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }

    protected Map<String, Object> resolveBeanMetadata(Object bean) {
        LinkedHashMap<String, Object> beanMetadata = new LinkedHashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null || !AbstractDubboMetadata.isSimpleType(propertyDescriptor.getPropertyType())) continue;
                String name = Introspector.decapitalize(propertyDescriptor.getName());
                Object value = readMethod.invoke(bean, new Object[0]);
                beanMetadata.put(name, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return beanMetadata;
    }

    protected Map<String, ServiceBean> getServiceBeansMap() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ServiceBean.class);
    }

    protected Map<String, ProtocolConfig> getProtocolConfigsBeanMap() {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class);
    }
}

