/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.autoconfigure;

import com.alibaba.dubbo.config.RegistryConfig;
import com.thebeastshop.kit.actuator.config.ActuatorPortInit;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerServiceImpl;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckConsumerFactoryBean;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboCheckProviderInit;
import com.thebeastshop.kit.actuator.dubbo.checker.config.DubboMetaBeanGetter;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={RegistryConfig.class})
public class DubboCheckerAutoConfiguration {
    @Bean
    public ActuatorPortInit actuatorPortInit(ManagementServerProperties managementServerProperties) {
        return new ActuatorPortInit(managementServerProperties);
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> metricsCommonTags(Environment environment) {
        String appId = environment.getProperty("appId");
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        return registry -> registry.config().commonTags(new String[]{"application", appId});
    }

    @Bean(value={"dubboCheckerOriginalService"})
    public DubboCheckerService dubboCheckerService() {
        return new DubboCheckerServiceImpl();
    }

    @Bean
    public DubboMetaBeanGetter dubboMetaBeanGetter() {
        return new DubboMetaBeanGetter();
    }

    @Bean
    public DubboCheckProviderInit checkProviderInit(DubboMetaBeanGetter dubboMetaBeanGetter, DubboCheckerService dubboCheckerOriginalService) {
        return new DubboCheckProviderInit(dubboCheckerOriginalService);
    }

    @Bean(value={"dubboCheckerService"})
    public DubboCheckConsumerFactoryBean dubboCheckConsumerFactoryBean(DubboCheckProviderInit dubboCheckProviderInit, DubboMetaBeanGetter dubboMetaBeanGetter) {
        return new DubboCheckConsumerFactoryBean();
    }
}

