package com.thebeastshop.kit.actuator.dubbo.health.biz.filter;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import org.apache.commons.lang3.time.StopWatch;

@Activate(group = {Constants.PROVIDER},order = -10000)
public class DubboHealthBizFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if(invoker.getInterface() == DubboCheckerService.class){
            return invoker.invoke(invocation);
        }

        StopWatch sw = StopWatch.createStarted();
        Result result = invoker.invoke(invocation);
        sw.stop();
        DubboHealthBizData.addOneTotalCount();
        if(sw.getTime() > DubboHealthBizData.HEALTH_TIMEOUT_MILLISECONDS){
            DubboHealthBizData.addOneTimeoutCount();
        }
        return result;
    }
}
