package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.health.DubboInvokeHealthIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class DubboBizInvokeHealthIndicator extends AbstractHealthIndicator {

    private Logger log = LoggerFactory.getLogger(DubboInvokeHealthIndicator.class);

    @Override
    protected void doHealthCheck(Health.Builder builder) {
        log.info("[beast-kit-actuator] time area:[{}],total invoke count:[{}],timeout invoke count:[{}]",
                DubboHealthBizData.IntervalSecondsOfClearTimeAndNow(),
                DubboHealthBizData.getTimeAreaTotalInvokeCount(),
                DubboHealthBizData.getTimeAreaTimeoutInvokeCount());
        builder.withDetail("timeArea",DubboHealthBizData.IntervalSecondsOfClearTimeAndNow());
        builder.withDetail("timeAreaTotalInvokeCount",DubboHealthBizData.getTimeAreaTotalInvokeCount());
        builder.withDetail("timeAreaTimeoutInvokeCount",DubboHealthBizData.getTimeAreaTimeoutInvokeCount());
        if (DubboHealthBizData.getTimeoutCountRate() >= DubboHealthBizData.TIMEOUT_COUNT_THRESHOLD) {
            builder.down();
        } else {
            builder.up();
        }
        DubboHealthBizData.clear();
    }
}
