package com.thebeastshop.kit.actuator.dubbo.health;

import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;


/**
 * Dubbo {@link HealthIndicator} Properties
 *
 * @see HealthIndicator
 * @since 2.7.0
 */
@ConfigurationProperties(prefix = DubboHealthIndicatorProperties.PREFIX, ignoreUnknownFields = false)
public class DubboHealthIndicatorProperties {

    /**
     * The prefix of {@link DubboHealthIndicatorProperties}
     */
    public static final String PREFIX = "management.health.dubbo";

    private Status status = new Status();

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * The nested class for {@link com.alibaba.dubbo.common.status.StatusChecker}'s names
     * <pre>
     * registry= org.apache.dubbo.registry.status.RegistryStatusChecker
     * spring= org.apache.dubbo.config.spring.status.SpringStatusChecker
     * datasource= org.apache.dubbo.config.spring.status.DataSourceStatusChecker
     * memory= org.apache.dubbo.common.status.support.MemoryStatusChecker
     * load= org.apache.dubbo.common.status.support.LoadStatusChecker
     * server= org.apache.dubbo.rpc.protocol.dubbo.status.ServerStatusChecker
     * threadpool= org.apache.dubbo.rpc.protocol.dubbo.status.ThreadPoolStatusChecker
     * </pre>
     *
     * @see com.alibaba.dubbo.common.status.StatusChecker
     */
    public static class Status {

        /**
         * The defaults names of {@link com.alibaba.dubbo.common.status.StatusChecker}
         * <p>
         * The defaults : "server", "memory", "load", "registry", "threadpool"
         */
        private Set<String> defaults = new LinkedHashSet<>(Arrays.asList(
                "server", "memory", "load", "registry", "threadpool"));

        /**
         * The extra names of {@link com.alibaba.dubbo.common.status.StatusChecker}
         */
        private Set<String> extras = new LinkedHashSet<>();

        public Set<String> getDefaults() {
            return defaults;
        }

        public void setDefaults(Set<String> defaults) {
            this.defaults = defaults;
        }

        public Set<String> getExtras() {
            return extras;
        }

        public void setExtras(Set<String> extras) {
            this.extras = extras;
        }
    }

}
