/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk;

import com.thebeastshop.dts.sdk.annotation.DTSTable;
import com.thebeastshop.dts.sdk.annotation.DTSTableValueGetter;
import com.thebeastshop.dts.sdk.handler.IDTSHandler;
import com.thebeastshop.dts.vo.RegisterInfo;
import com.thebeastshop.dts.vo.RegisterItem;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSHandlerManager {
    private static Logger log = LoggerFactory.getLogger(DTSHandlerManager.class);
    private static final Map<String, IDTSHandler> handlerMap = new HashMap<String, IDTSHandler>();

    public static void addHandler(IDTSHandler handler) {
        DTSTable dtsTable = handler.getClass().getAnnotation(DTSTable.class);
        String dtsTableValue = DTSTableValueGetter.getValue(dtsTable);
        handlerMap.put(dtsTableValue, handler);
    }

    public static IDTSHandler getHandler(String tableName) {
        if (handlerMap.containsKey(tableName)) {
            return handlerMap.get(tableName);
        }
        for (Map.Entry<String, IDTSHandler> entry : handlerMap.entrySet()) {
            String[] regArray;
            for (String reg : regArray = entry.getKey().split("[ \t\n\r]*,[ \t\n\r]*")) {
                boolean flag = Pattern.matches(reg, tableName);
                if (!flag) continue;
                return handlerMap.get(entry.getKey());
            }
        }
        return null;
    }

    public static Map<String, IDTSHandler> getHandlerMap() {
        return handlerMap;
    }

    public static void refreshHandlerConfig(RegisterInfo registerInfo) {
        for (IDTSHandler handler : handlerMap.values()) {
            handler.clearRegisterItems();
        }
        for (RegisterItem item : registerInfo.getRegisterItems()) {
            IDTSHandler handler = DTSHandlerManager.getHandler(item.getTableName());
            if (handler == null) continue;
            handler.addRegisterItem(item);
        }
    }
}

