/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcJoinDTO;
import com.thebeastshop.dc.api.dto.DcParamDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.dto.DcSelectionDTO;
import com.thebeastshop.dc.api.primary.AbstractQuery;
import com.thebeastshop.dc.api.primary.AbstractWhere;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.primary.DcJoinBlock;
import com.thebeastshop.dc.api.primary.DcLambdaWhere;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public final class DcLambdaQuery<TABLE extends DcTableVO>
extends AbstractQuery<DcLambdaQuery<TABLE>, TABLE, DcGetter<TABLE, ?>, Function<DcLambdaQuery<TABLE>, DcLambdaQuery<TABLE>>> {
    private final List<DcJoinBlock> joinList = new ArrayList<DcJoinBlock>();

    public DcLambdaQuery(Class<TABLE> tableClass) {
        super(tableClass);
    }

    @Override
    protected DcLambdaQuery<TABLE> newSelfInstance() {
        return new DcLambdaQuery<TABLE>(this.tableClass);
    }

    @Override
    protected <T extends DcTableVO> AbstractWhere createWhere(Class<T> tableClass) {
        return new DcLambdaWhere<T>(tableClass);
    }

    @Override
    public <OTHER_TABLE extends DcTableVO, JOIN extends DcLambdaWhere<OTHER_TABLE>> DcLambdaQuery<TABLE> join(Class<OTHER_TABLE> tableClass, Function<JOIN, JOIN> join) {
        this.joinList.add(new DcJoinBlock<OTHER_TABLE>(tableClass, join));
        return (DcLambdaQuery)this.self;
    }

    @Override
    public DcQueryDTO toDTO() {
        DcQueryDTO dto = super.toDTO();
        DcSelectionDTO selectionDTO = new DcSelectionDTO();
        if (CollectionUtils.isNotEmpty((Collection)this.includeList)) {
            selectionDTO.addIncludeColumns(this.includeList.stream().map(getter -> QueryUtil.getColumnName(this.tableClass, getter)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)this.excludeList)) {
            selectionDTO.addExcludeColumns(this.excludeList.stream().map(getter -> QueryUtil.getColumnName(this.tableClass, getter)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)this.includeTableList)) {
            selectionDTO.addIncludeColumns(this.includeTableList.stream().filter(tClass -> !this.includeTableColumnMap.containsKey(tClass)).map(QueryUtil::getJoinPath).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)this.excludeTableList)) {
            selectionDTO.addExcludeColumns(this.excludeTableList.stream().filter(tClass -> !this.excludeTableColumnMap.containsKey(tClass)).map(QueryUtil::getJoinPath).collect(Collectors.toList()));
        }
        if (MapUtils.isNotEmpty((Map)this.includeTableColumnMap)) {
            this.includeTableColumnMap.forEach((tClass, columnList) -> selectionDTO.addIncludeColumns(columnList.stream().map(getter -> QueryUtil.getColumnName(tClass, getter)).collect(Collectors.toList())));
        }
        if (MapUtils.isNotEmpty((Map)this.excludeTableColumnMap)) {
            this.excludeTableColumnMap.forEach((tClass, columnList) -> selectionDTO.addExcludeColumns(columnList.stream().map(getter -> QueryUtil.getColumnName(tClass, getter)).collect(Collectors.toList())));
        }
        if (CollectionUtils.isNotEmpty(selectionDTO.getIncludes()) || CollectionUtils.isNotEmpty(selectionDTO.getExcludes())) {
            dto.setSelect(selectionDTO);
        }
        for (DcJoinBlock joinBlock : this.joinList) {
            Class tableClass = joinBlock.getTableClass();
            AbstractWhere joinWhere = this.createWhere(tableClass);
            Object ret = joinBlock.getBlock().apply(joinWhere);
            if (ret != null && ret instanceof DcLambdaQuery) {
                joinWhere = (DcLambdaWhere)ret;
            }
            DcQueryDTO joinQueryDTO = joinWhere.getQuery().toDTO();
            if (dto.getCond().getAnd() == null) {
                dto.getCond().setAnd(new LinkedList<DcParamDTO>());
            }
            String path = QueryUtil.getJoinPath(joinBlock.getTableClass());
            DcJoinDTO joinDTO = new DcJoinDTO();
            joinDTO.setPath(path);
            joinDTO.setJoin(joinQueryDTO.getCond());
            dto.getCond().addAnd(joinDTO);
        }
        return dto;
    }
}

