/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcCompareDTO;
import com.thebeastshop.dc.api.dto.DcConditionDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.dto.DcSelectionDTO;
import com.thebeastshop.dc.api.dto.DcSortDTO;
import com.thebeastshop.dc.api.primary.AbstractWhere;
import com.thebeastshop.dc.api.primary.DcCompare;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.primary.DcOp;
import com.thebeastshop.dc.api.primary.DcParam;
import com.thebeastshop.dc.api.primary.DcQuery;
import com.thebeastshop.dc.api.primary.DcSort;
import com.thebeastshop.dc.api.primary.DcSortType;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractQuery<SELF extends AbstractQuery<SELF, TABLE, COLUMN, BLOCK>, TABLE extends DcTableVO, COLUMN extends DcGetter, BLOCK extends Function<SELF, SELF>>
implements DcQuery<SELF, TABLE, COLUMN, BLOCK> {
    protected final SELF self = this;
    protected final Class<TABLE> tableClass;
    protected Integer offset;
    protected Integer size;
    protected final List<COLUMN> includeList = new ArrayList<COLUMN>();
    protected final List<COLUMN> excludeList = new ArrayList<COLUMN>();
    protected final List<Class<? extends DcTableVO>> includeTableList = new ArrayList<Class<? extends DcTableVO>>();
    protected final List<Class<? extends DcTableVO>> excludeTableList = new ArrayList<Class<? extends DcTableVO>>();
    protected final Map<Class<? extends DcTableVO>, List<DcGetter<? extends DcTableVO, ?>>> includeTableColumnMap = new LinkedHashMap();
    protected final Map<Class<? extends DcTableVO>, List<DcGetter<? extends DcTableVO, ?>>> excludeTableColumnMap = new LinkedHashMap();
    protected final List<DcParam> paramList = new ArrayList<DcParam>();
    protected final List<DcParam> matchList = new ArrayList<DcParam>();
    protected final List<BLOCK> andList = new ArrayList<BLOCK>();
    protected final List<BLOCK> orList = new ArrayList<BLOCK>();
    protected final List<BLOCK> notList = new ArrayList<BLOCK>();
    protected final List<DcSort> sortList = new ArrayList<DcSort>();

    protected AbstractQuery(Class<TABLE> tableClass) {
        this.tableClass = tableClass;
    }

    Class<TABLE> getTableClass() {
        return this.tableClass;
    }

    @Override
    public <OTHER_TABLE extends DcTableVO> SELF oneToOne(DcGetter<TABLE, OTHER_TABLE> joinColumn) {
        return this.self;
    }

    @Override
    public <OTHER_TABLE extends DcTableVO, COLLECTION extends Collection<OTHER_TABLE>> SELF oneToMany(DcGetter<TABLE, COLLECTION> joinColumn) {
        return this.self;
    }

    protected abstract SELF newSelfInstance();

    protected abstract <T extends DcTableVO> AbstractWhere createWhere(Class<T> var1);

    @Override
    @SafeVarargs
    public final SELF include(COLUMN ... columns) {
        this.includeList.addAll(Arrays.asList(columns));
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF exclude(COLUMN ... columns) {
        this.excludeList.addAll(Arrays.asList(columns));
        return this.self;
    }

    @Override
    public <T extends DcTableVO> SELF include(Class<T> tableClass) {
        this.includeTableList.add(tableClass);
        return this.self;
    }

    @Override
    @SafeVarargs
    public final <T extends DcTableVO, COL extends DcGetter<? extends T, ?>> SELF include(Class<T> tableClass, COL ... columns) {
        List<COL> colList = Arrays.asList(columns);
        if (CollectionUtils.isEmpty(colList)) {
            this.includeTableList.add(tableClass);
        } else {
            this.includeTableColumnMap.computeIfAbsent(tableClass, k -> new ArrayList()).addAll(colList);
        }
        return this.self;
    }

    @Override
    public <T extends DcTableVO> SELF exclude(Class<T> tableClass) {
        this.excludeTableList.add(tableClass);
        return this.self;
    }

    @Override
    @SafeVarargs
    public final <T extends DcTableVO, COL extends DcGetter<? extends T, ?>> SELF exclude(Class<T> tableClass, COL ... columns) {
        List<COL> colList = Arrays.asList(columns);
        if (CollectionUtils.isEmpty(colList)) {
            this.excludeTableList.add(tableClass);
        } else {
            this.excludeTableColumnMap.computeIfAbsent(tableClass, k -> new ArrayList()).addAll(colList);
        }
        return this.self;
    }

    @Override
    public SELF limit(Integer from, int size) {
        this.offset = from;
        this.size = size;
        return this.self;
    }

    @Override
    public SELF limit(int size) {
        this.size = size;
        return this.self;
    }

    public SELF offset(int offset) {
        this.offset = offset;
        return this.self;
    }

    public Integer offset() {
        return this.offset;
    }

    public SELF size(int size) {
        this.size = size;
        return this.self;
    }

    public Integer size() {
        return this.size;
    }

    @Override
    public SELF sort(DcSort ... sorts) {
        for (DcSort sort : sorts) {
            this.sortList.add(sort);
        }
        return this.self;
    }

    @Override
    public SELF sortASC(COLUMN column) {
        return (SELF)this.sort(new DcSort[]{new DcSort<COLUMN>(DcSortType.ASC, column)});
    }

    @Override
    public SELF sortDESC(COLUMN column) {
        return (SELF)this.sort(new DcSort[]{new DcSort<COLUMN>(DcSortType.DESC, column)});
    }

    private SELF addCompare(COLUMN column, DcOp op, Object value) {
        if (value != null) {
            QueryUtil.checkColumn(this.tableClass, column, value);
        }
        this.paramList.add(new DcCompare<COLUMN>(column, op, value));
        return this.self;
    }

    private SELF addMatch(COLUMN column, DcOp op, Object value) {
        if (value != null) {
            QueryUtil.checkColumn(this.tableClass, column, value);
        }
        this.matchList.add(new DcCompare<COLUMN>(column, op, value));
        return this.self;
    }

    @Override
    public SELF eq(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.EQ, value);
    }

    @Override
    public SELF ne(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.NE, value);
    }

    @Override
    public SELF gt(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.GT, value);
    }

    @Override
    public SELF ge(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.GE, value);
    }

    @Override
    public SELF lt(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LT, value);
    }

    @Override
    public SELF le(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LE, value);
    }

    @Override
    public SELF in(COLUMN column, Object ... values) {
        return this.addCompare(column, DcOp.IN, Arrays.asList(values));
    }

    @Override
    public SELF in(COLUMN column, Collection values) {
        return this.addCompare(column, DcOp.IN, values);
    }

    @Override
    public SELF exists(COLUMN column) {
        return this.addCompare(column, DcOp.EXISTS, null);
    }

    @Override
    public SELF match(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.MATCH, value);
    }

    @Override
    public SELF matchPrefix(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.MATCH_PREFIX, value);
    }

    @Override
    public SELF like(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LIKE, value);
    }

    @Override
    public SELF notIn(COLUMN column, Object ... values) {
        return this.addCompare(column, DcOp.NOT_IN, values);
    }

    @Override
    public SELF notExists(COLUMN column) {
        return this.addCompare(column, DcOp.NOT_EXISTS, null);
    }

    @Override
    public SELF notMatch(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.NOT_MATCH, value);
    }

    @Override
    public SELF notMatchPrefix(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.NOT_MATCH_PREFIX, value);
    }

    @Override
    @SafeVarargs
    public final SELF and(BLOCK ... conditions) {
        this.andList.addAll(Arrays.asList(conditions));
        return this.self;
    }

    @Override
    public final SELF not(BLOCK condition) {
        this.notList.add(condition);
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF or(BLOCK ... conditions) {
        this.orList.addAll(Arrays.asList(conditions));
        return this.self;
    }

    @Override
    public DcQueryDTO toDTO() {
        AbstractQuery ret;
        SELF orQuery;
        DcQueryDTO dto = new DcQueryDTO();
        if (this.offset != null) {
            dto.setOffset(this.offset);
        }
        if (this.size != null) {
            dto.setSize(this.size);
        }
        if (CollectionUtils.isNotEmpty(this.sortList)) {
            dto.setSorts(this.sortList.stream().map(sort -> {
                DcSortDTO sortDTO = new DcSortDTO();
                sortDTO.setType(sort.getType());
                sortDTO.setColumn(QueryUtil.getColumnName(this.tableClass, sort.getColumn()));
                return sortDTO;
            }).collect(Collectors.toList()));
        }
        DcSelectionDTO selectionDTO = new DcSelectionDTO();
        for (DcGetter column : this.includeList) {
            selectionDTO.addIncludeColumn(QueryUtil.getColumnName(this.tableClass, column));
        }
        for (DcGetter column : this.excludeList) {
            selectionDTO.addIncludeColumn(QueryUtil.getColumnName(this.tableClass, column));
        }
        dto.setSelect(selectionDTO);
        DcConditionDTO conditionDTO = new DcConditionDTO();
        dto.setCond(conditionDTO);
        for (DcParam param : this.paramList) {
            if (!(param instanceof DcCompare)) continue;
            DcCompare compare = (DcCompare)param;
            DcCompareDTO compareDTO = compare.toDTO(this.tableClass);
            if (compare.isNegative()) {
                conditionDTO.addNot(compareDTO);
                continue;
            }
            if (compare.isMatch()) {
                conditionDTO.addMatch(compareDTO);
                continue;
            }
            conditionDTO.addAnd(compareDTO);
        }
        for (Function and : this.andList) {
            try {
                orQuery = this.newSelfInstance();
                ret = (AbstractQuery)and.apply(orQuery);
                if (ret == null) continue;
                conditionDTO.addAnd(ret.toDTO().getCond());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        for (Function not : this.notList) {
            try {
                SELF notQuery = this.newSelfInstance();
                ret = (AbstractQuery)not.apply(notQuery);
                if (ret == null) continue;
                conditionDTO.addNot(ret.toDTO().getCond());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        for (Function or : this.orList) {
            try {
                orQuery = this.newSelfInstance();
                ret = (AbstractQuery)or.apply(orQuery);
                if (ret == null) continue;
                conditionDTO.addOr(ret.toDTO().getCond());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return dto;
    }
}

