/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.utils;

import com.thebeastshop.datahub.common.enums.MessageOperationEnum;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.spi.MessageHandlerProvider;
import com.thebeastshop.datahub.common.vo.BusinessMessage;
import java.nio.ByteBuffer;

public final class BusinessMessageUtils {
    private static final byte VERSION = 1;

    public static byte[] encode(BusinessMessage message) {
        short headLength;
        short fullLength = headLength = 3;
        byte[] dataBytes = MessageHandlerProvider.getHandler(message.getProtocol()).serialize(message.getDatas());
        ByteBuffer buffer = ByteBuffer.allocate(6 + (fullLength += dataBytes.length));
        buffer.putShort(headLength);
        buffer.putInt(fullLength);
        buffer.put((byte)1);
        buffer.put(message.getOperation().code);
        buffer.put(message.getProtocol().code);
        buffer.put(dataBytes);
        return buffer.array();
    }

    public static BusinessMessage decode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short headLength = buffer.getShort();
        int fullLength = buffer.getInt();
        byte version = buffer.get();
        byte operation = buffer.get();
        MessageProtocolEnum protocol = MessageProtocolEnum.getEnumByCode(buffer.get());
        byte[] bs = new byte[fullLength - headLength];
        buffer.get(bs);
        BusinessMessage message = new BusinessMessage();
        message.setOperation(MessageOperationEnum.getEnumByCode(operation));
        message.setProtocol(protocol);
        message.setDatas(MessageHandlerProvider.getHandler(protocol).deserialize(bs));
        return message;
    }
}

