/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.spi.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.spi.MessageHandler;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoMessageHandler
implements MessageHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public MessageProtocolEnum getProtocol() {
        return MessageProtocolEnum.KRYO;
    }

    @Override
    public byte[] serialize(List<BusinessRecord> datas) {
        byte[] bytes = null;
        try (ByteBufferOutput output = new ByteBufferOutput(1024, -1);){
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.writeObject((Output)output, datas);
            output.flush();
            bytes = output.toBytes();
        }
        catch (Exception ex) {
            this.log.error("[DATAHUB] [KRYO\u64cd\u4f5c\u5668] \u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)ex);
        }
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BusinessRecord> deserialize(byte[] data) {
        try (ByteBufferInput input = new ByteBufferInput(data);){
            List record;
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            List list = record = (List)kryo.readObject((Input)input, ArrayList.class);
            return list;
        }
        catch (Exception ex) {
            this.log.error("[DATAHUB] [KRYO\u64cd\u4f5c\u5668] \u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }
}

