/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.enums;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum DataTypeEnum {
    BYTE(new Class[]{Byte.class, Byte.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Byte.valueOf(obj.toString());
            } else if (!(obj instanceof Byte)) {
                obj = ((Number)obj).byteValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return new byte[]{(Byte)this.castValue(obj, null)};
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return bytes[0];
            }
            return null;
        }
    }
    ,
    SHORT(new Class[]{Short.class, Short.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Short.valueOf(obj.toString());
            } else if (!(obj instanceof Short)) {
                obj = ((Number)obj).shortValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Shorts.toByteArray((short)((Short)this.castValue(obj, null)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Shorts.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    INT(new Class[]{Integer.class, Integer.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Integer.valueOf(obj.toString());
            } else if (!(obj instanceof Integer)) {
                obj = ((Number)obj).intValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Ints.toByteArray((int)((Integer)this.castValue(obj, null)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Ints.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    LONG(new Class[]{Long.class, Long.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Long.valueOf(obj.toString());
            } else if (!(obj instanceof Long)) {
                obj = ((Number)obj).longValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Longs.toByteArray((long)((Long)this.castValue(obj, null)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Longs.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    FLOAT(new Class[]{Float.class, Float.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Float.valueOf(obj.toString());
            } else if (!(obj instanceof Float)) {
                obj = Float.valueOf(((Number)obj).floatValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return ByteBuffer.allocate(4).putFloat(((Float)this.castValue(obj, null)).floatValue()).array();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
            }
            return null;
        }
    }
    ,
    DOUBLE(new Class[]{Double.class, Double.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Double.valueOf(obj.toString());
            } else if (!(obj instanceof Double)) {
                obj = ((Number)obj).doubleValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return ByteBuffer.allocate(8).putDouble((Double)this.castValue(obj, null)).array();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return ByteBuffer.wrap(bytes).getDouble();
            }
            return null;
        }
    }
    ,
    BIG_DECIMAL(new Class[]{BigDecimal.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = new BigDecimal(obj.toString());
            } else if (!(obj instanceof BigDecimal)) {
                obj = new BigDecimal(((Number)obj).doubleValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                BigDecimal num = (BigDecimal)this.castValue(obj, null);
                BigInteger unscaledValue = num.unscaledValue();
                int scale = num.scale();
                byte[] scaleBytes = new byte[]{(byte)(scale >>> 24), (byte)(scale >>> 16), (byte)(scale >>> 8), (byte)scale};
                return ArrayUtils.addAll((byte[])scaleBytes, (byte[])unscaledValue.toByteArray());
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                int scale = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
                BigInteger unscaledValue = new BigInteger(ArrayUtils.subarray((byte[])bytes, (int)4, (int)bytes.length));
                return new BigDecimal(unscaledValue, scale);
            }
            return null;
        }
    }
    ,
    BOOLEAN(new Class[]{Boolean.class, Boolean.TYPE}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                obj = Boolean.valueOf(obj.toString());
            } else if (!(obj instanceof Boolean)) {
                obj = new Boolean(obj.toString());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return new byte[]{(Boolean)this.castValue(obj, null) != false ? (byte)1 : 0};
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return bytes[0] == 1;
            }
            return null;
        }
    }
    ,
    DATE(new Class[]{Date.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj != null && obj instanceof Number) {
                obj = new Date(((Number)obj).longValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Longs.toByteArray((long)((Date)this.castValue(obj, null)).getTime());
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new Date(Longs.fromByteArray((byte[])bytes));
            }
            return null;
        }
    }
    ,
    STRING(new Class[]{String.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj != null && !(obj instanceof String)) {
                obj = obj.toString();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    }
    ,
    LIST(new Class[]{Collection.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            String json = List.class.isAssignableFrom(obj.getClass()) ? JSON.toJSONString((Object)obj) : obj.toString();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                if (genericType != null) {
                    return JSON.parseObject((String)json, (Type)genericType, (Feature[])new Feature[0]);
                }
                return JSON.parseArray((String)json);
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return JSONArray.toJSONString((Object)obj).getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                String str = new String(bytes);
                return str;
            }
            return null;
        }
    }
    ,
    MAP(new Class[]{Map.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            String json = Map.class.isAssignableFrom(obj.getClass()) ? JSON.toJSONString((Object)obj) : obj.toString();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                if (genericType != null) {
                    return JSON.parseObject((String)json, (Type)genericType, (Feature[])new Feature[0]);
                }
                return JSON.parseObject((String)json);
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    }
    ,
    ENUM(new Class[]{Enum.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (genericType == null) {
                return obj.toString();
            }
            if (!Enum.class.isAssignableFrom(obj.getClass())) {
                String str = obj.toString();
                return Enum.valueOf((Class)genericType, str.toUpperCase());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                if (obj instanceof Enum) {
                    return ((Enum)obj).name().getBytes();
                }
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                String str = new String(bytes);
                return str;
            }
            return null;
        }
    }
    ,
    OBJECT(new Class[]{Object.class}){

        @Override
        public Object castValue(Object obj, Type genericType) {
            if (obj == null) {
                return null;
            }
            if (genericType == null) {
                String json = String.class.isAssignableFrom(obj.getClass()) ? obj.toString() : JSON.toJSONString((Object)obj);
                return JSON.parseObject((String)json);
            }
            if (!((Class)genericType).isAssignableFrom(obj.getClass())) {
                String json = String.class.isAssignableFrom(obj.getClass()) ? obj.toString() : JSON.toJSONString((Object)obj);
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                return JSON.parseObject((String)json, (Type)genericType, (Feature[])new Feature[0]);
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                String json = JSON.toJSONString((Object)obj);
                return json.getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                String jsonStr = new String(bytes);
                return jsonStr;
            }
            return null;
        }
    };

    public final HashSet<Class<?>> types = new HashSet();

    private DataTypeEnum(Class<?> ... types) {
        Arrays.asList(types).stream().forEach(item -> this.types.add((Class<?>)item));
    }

    public abstract Object castValue(Object var1, Type var2);

    public abstract byte[] object2Bytes(Object var1);

    public abstract Object bytes2Object(byte[] var1);

    public static DataTypeEnum getEnumByType(Class<?> type) {
        for (DataTypeEnum value : DataTypeEnum.values()) {
            if (value.types.contains(type)) {
                return value;
            }
            for (Class<?> clazz : value.types) {
                if (!clazz.isAssignableFrom(type)) continue;
                return value;
            }
        }
        return null;
    }
}

