/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.common.bgel;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.ast.ASTDate;
import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTIdentifier;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelEvalVisitor;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.util.LinkedList;
import org.antlr.v4.runtime.Token;

public class DHCriteriaASTVisitor
extends BgelEvalVisitor {
    public void visitIdentifier(BgelRuntimeContext context, ASTIdentifier node) {
        String idName = node.getName();
        context.setResult((Object)idName);
    }

    public void visitDate(BgelRuntimeContext context, ASTDate node) {
        super.visitDate(context, node);
        BgelDate bgelDate = (BgelDate)context.getResult();
        context.setResult((Object)bgelDate.getDate());
    }

    public void visitBinaryExpression(BgelRuntimeContext context, ASTBinaryExpression node) {
        Token op = node.getOperation();
        int opType = op.getType();
        switch (opType) {
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: {
                CriteriaOperatorEnum criteriaOp = this.transformOp(op);
                ASTExpression leftExpr = node.getLeft();
                ASTExpression rightExpr = node.getRight();
                leftExpr.visit(context, (ASTVisitor)this);
                Object left = context.getResult();
                rightExpr.visit(context, (ASTVisitor)this);
                Object right = context.getResult();
                CriteriaNode criteriaNode = new CriteriaNode();
                criteriaNode.setOp(criteriaOp);
                switch (opType) {
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 32: {
                        criteriaNode.setKey(left.toString());
                        criteriaNode.setValue(MetaHelper.unwrap((Object)right));
                    }
                }
                switch (opType) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
                        if (left instanceof CriteriaNode) {
                            if (((CriteriaNode)left).getOp() == criteriaOp) {
                                for (CriteriaNode child : ((CriteriaNode)left).getChildren()) {
                                    nodeList.add(child);
                                }
                            } else {
                                nodeList.add((CriteriaNode)left);
                            }
                        } else {
                            nodeList.add((CriteriaNode)left);
                        }
                        nodeList.add((CriteriaNode)right);
                        criteriaNode.setChildren(nodeList);
                    }
                }
                context.setResult((Object)criteriaNode);
                return;
            }
        }
        super.visitBinaryExpression(context, node);
    }

    private CriteriaOperatorEnum transformOp(Token op) {
        switch (op.getType()) {
            case 22: 
            case 24: {
                return CriteriaOperatorEnum.AND;
            }
            case 23: 
            case 25: {
                return CriteriaOperatorEnum.OR;
            }
            case 13: {
                return CriteriaOperatorEnum.LT;
            }
            case 12: {
                return CriteriaOperatorEnum.GT;
            }
            case 17: {
                return CriteriaOperatorEnum.LE;
            }
            case 16: {
                return CriteriaOperatorEnum.GE;
            }
            case 18: {
                return CriteriaOperatorEnum.EQ;
            }
            case 19: {
                return CriteriaOperatorEnum.NE;
            }
            case 32: {
                return CriteriaOperatorEnum.IN;
            }
        }
        throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a \u4e0d\u652f\u6301\u64cd\u4f5c\u7b26'" + op.getText() + "'!");
    }
}

