/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.enums;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public enum DataTypeEnum {
    BYTE(new Class[]{Byte.class, Byte.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Byte)) {
                obj = ((Number)obj).byteValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return new byte[]{(Byte)this.castValue(obj)};
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return bytes[0];
            }
            return null;
        }
    }
    ,
    SHORT(new Class[]{Short.class, Short.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Short)) {
                obj = ((Number)obj).shortValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Shorts.toByteArray((short)((Short)this.castValue(obj)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Shorts.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    INT(new Class[]{Integer.class, Integer.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Integer)) {
                obj = ((Number)obj).intValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Ints.toByteArray((int)((Integer)this.castValue(obj)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Ints.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    LONG(new Class[]{Long.class, Long.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Long)) {
                obj = ((Number)obj).longValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Longs.toByteArray((long)((Long)this.castValue(obj)));
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Longs.fromByteArray((byte[])bytes);
            }
            return null;
        }
    }
    ,
    FLOAT(new Class[]{Float.class, Float.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Float)) {
                obj = Float.valueOf(((Number)obj).floatValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return ByteBuffer.allocate(4).putFloat(((Float)this.castValue(obj)).floatValue()).array();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return Float.valueOf(ByteBuffer.wrap(bytes).getFloat());
            }
            return null;
        }
    }
    ,
    DOUBLE(new Class[]{Double.class, Double.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Double)) {
                obj = ((Number)obj).doubleValue();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return ByteBuffer.allocate(8).putDouble((Double)this.castValue(obj)).array();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return ByteBuffer.wrap(bytes).getDouble();
            }
            return null;
        }
    }
    ,
    BIG_DECIMAL(new Class[]{BigDecimal.class}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof BigDecimal)) {
                obj = new BigDecimal(((Number)obj).doubleValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                BigDecimal num = (BigDecimal)this.castValue(obj);
                BigInteger unscaledValue = num.unscaledValue();
                int scale = num.scale();
                byte[] scaleBytes = new byte[]{(byte)(scale >>> 24), (byte)(scale >>> 16), (byte)(scale >>> 8), (byte)scale};
                return ArrayUtils.addAll((byte[])scaleBytes, (byte[])unscaledValue.toByteArray());
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                int scale = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
                BigInteger unscaledValue = new BigInteger(ArrayUtils.subarray((byte[])bytes, (int)4, (int)bytes.length));
                return new BigDecimal(unscaledValue, scale);
            }
            return null;
        }
    }
    ,
    BOOLEAN(new Class[]{Boolean.class, Boolean.TYPE}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof Boolean)) {
                obj = new Boolean(obj.toString());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return new byte[]{(Boolean)this.castValue(obj) != false ? (byte)1 : 0};
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return bytes[0] == 1;
            }
            return null;
        }
    }
    ,
    DATE(new Class[]{Date.class}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && obj instanceof Number) {
                obj = new Date(((Number)obj).longValue());
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return Longs.toByteArray((long)((Date)this.castValue(obj)).getTime());
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new Date(Longs.fromByteArray((byte[])bytes));
            }
            return null;
        }
    }
    ,
    STRING(new Class[]{String.class}){

        @Override
        public Object castValue(Object obj) {
            if (obj != null && !(obj instanceof String)) {
                obj = obj.toString();
            }
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    }
    ,
    LIST(new Class[]{Collection.class}){

        @Override
        public Object castValue(Object obj) {
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    }
    ,
    MAP(new Class[]{Map.class}){

        @Override
        public Object castValue(Object obj) {
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    }
    ,
    OBJECT(new Class[]{Object.class}){

        @Override
        public Object castValue(Object obj) {
            return obj;
        }

        @Override
        public byte[] object2Bytes(Object obj) {
            if (obj != null) {
                return obj.toString().getBytes();
            }
            return null;
        }

        @Override
        public Object bytes2Object(byte[] bytes) {
            if (bytes != null && bytes.length > 0) {
                return new String(bytes);
            }
            return null;
        }
    };

    public List<Class<?>> types;

    private DataTypeEnum(Class<?> ... types) {
        this.types = Arrays.asList(types);
    }

    public abstract Object castValue(Object var1);

    public abstract byte[] object2Bytes(Object var1);

    public abstract Object bytes2Object(byte[] var1);

    public static DataTypeEnum getEnumByType(Class<?> type) {
        for (DataTypeEnum value : DataTypeEnum.values()) {
            if (value.types.contains(type)) {
                return value;
            }
            for (Class<?> clazz : value.types) {
                if (!clazz.isAssignableFrom(type)) continue;
                return value;
            }
        }
        return null;
    }
}

