/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.google.common.collect.Maps;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class DatahubMetaClass {
    private final String name;
    private final Class entityClass;
    private Map<String, DatahubProperty> businessProperties = new HashMap<String, DatahubProperty>();
    private Map<String, DatahubProperty> commonProperties = new HashMap<String, DatahubProperty>();

    DatahubMetaClass(Class entityClass, String name) {
        this.entityClass = entityClass;
        this.name = name;
        this.parseProperties();
    }

    private void parseProperties() {
        PropertyDescriptor[] targetPds;
        for (PropertyDescriptor propDes : targetPds = BeanUtils.getPropertyDescriptors((Class)this.entityClass)) {
            if (propDes.getName().equals("class")) continue;
            DatahubProperty property = new DatahubProperty(this.entityClass, propDes);
            if (property.isCommon()) {
                this.commonProperties.put(property.getCommonName(), property);
            }
            this.businessProperties.put(property.getName(), property);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public DatahubProperty getBusinessProperty(String name) {
        return this.businessProperties.get(name);
    }

    public Map<String, DatahubProperty> getBusinessProperties() {
        return this.businessProperties;
    }

    public Map<String, DatahubProperty> getCommonProperties() {
        return this.commonProperties;
    }

    public Map<String, DatahubProperty> getAllProperties() {
        HashMap allMap = Maps.newHashMap(this.commonProperties);
        allMap.putAll(this.businessProperties);
        return allMap;
    }

    public DatahubProperty getCommonProperty(String name) {
        return this.commonProperties.get(name);
    }

    public DatahubProperty getProperty(String name) {
        DatahubProperty property = this.getCommonProperty(name);
        if (property != null) {
            return property;
        }
        return this.getBusinessProperty(name);
    }

    public DatahubProperty getDbIdProperty() {
        return this.getCommonProperty("$id");
    }

    public boolean isCommonProperty(String propertyName) {
        return !this.isBusinessProperty(propertyName);
    }

    public boolean isBusinessProperty(String propertyName) {
        return this.businessProperties.containsKey(propertyName);
    }

    public DatahubProperty getAppIdProperty() {
        return this.getCommonProperty("$appId");
    }

    public DatahubProperty getCreatorProperty() {
        return this.getCommonProperty("$creator");
    }

    public DatahubProperty getReviserProperty() {
        return this.getCommonProperty("$reviser");
    }

    public DatahubProperty getCreateTimeProperty() {
        return this.getCommonProperty("$createTime");
    }

    public DatahubProperty getUpdateTimeProperty() {
        return this.getCommonProperty("$updateTime");
    }

    public <T> T getCommonPropertyValue(Object bean, String commonName, Class<T> returnClass) throws InvocationTargetException, IllegalAccessException {
        DatahubProperty property = this.getCommonProperty(commonName);
        if (property == null) {
            return null;
        }
        Object obj = property.getValue(bean);
        if (obj == null) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(returnClass)) {
            return (T)obj.toString();
        }
        return (T)obj;
    }

    public String getIdValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$id", String.class);
    }

    public String getAppIdValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$appId", String.class);
    }

    public String getCreatorValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$creator", String.class);
    }

    public String getReviserValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$reviser", String.class);
    }

    public Date getCreateTimeValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$createTime", Date.class);
    }

    public Date getUpdateTimeValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, "$updateTime", Date.class);
    }
}

