/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypeCaster {
    private static final Map<String, FieldValidation> COMMON_FIELD_VALID = new HashMap<String, FieldValidation>();
    private static final Map<Class, Map<String, Method>> SETTER_CACHE;

    private static String getStterName(String propName) {
        if (propName.length() == 1) {
            return "set" + propName.toUpperCase();
        }
        return "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
    }

    private static Method getSetter(Class entityClass, String setterName) {
        Method[] methods;
        for (Method method : methods = entityClass.getMethods()) {
            String methodName = method.getName();
            if (!methodName.equals(setterName) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Method getSetterFromCache(Class entityClass, String setterName) {
        Method setterMethod;
        Map<String, Method> methodCache = SETTER_CACHE.get(entityClass);
        if (methodCache == null) {
            Class<TypeCaster> clazz = TypeCaster.class;
            // MONITORENTER : com.thebeastshop.datahub.client.utils.TypeCaster.class
            if (methodCache == null) {
                Method[] methods;
                methodCache = new ConcurrentHashMap<String, Method>();
                for (Method method : methods = entityClass.getMethods()) {
                    String methodName = method.getName();
                    if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
                    methodCache.put(methodName, method);
                }
                SETTER_CACHE.put(entityClass, methodCache);
            }
            // MONITOREXIT : clazz
        }
        if ((setterMethod = methodCache.get(setterName)) != null) return setterMethod;
        Class<TypeCaster> clazz = TypeCaster.class;
        // MONITORENTER : com.thebeastshop.datahub.client.utils.TypeCaster.class
        if (setterMethod == null) {
            setterMethod = TypeCaster.getSetter(entityClass, setterName);
            methodCache.put(setterName, setterMethod);
        }
        // MONITOREXIT : clazz
        return setterMethod;
    }

    private static Object castValue(CriteriaNode criteriaNode, Class<?> entityClass, Class targetType, Object value) {
        try {
            value = MetaHelper.cast((Class)targetType, (Object)value);
            return value;
        }
        catch (Throwable th) {
            throw new RuntimeException("[DATAHUB] " + MetaUtils.getBusinessName(value.getClass()) + "(" + TypeCaster.valueString(value) + ") \u4e0d\u80fd\u8f6c\u5316\u4e3a\u5b57\u6bb5 " + MetaUtils.getBusinessName(entityClass) + "." + criteriaNode.getKey() + "\u7684\u7c7b\u578b[" + targetType + "]");
        }
    }

    public static void cast(CriteriaNode criteriaNode, Class<?> entityClass) {
        String key = criteriaNode.getKey();
        Object value = criteriaNode.getValue();
        if (key != null && value != null) {
            String targetSetterName;
            if (TypeCaster.isCommonField(key)) {
                if (!TypeCaster.hasRightToUseCommonField(key)) {
                    throw new RuntimeException("[DATAHUB] \u60a8\u6ca1\u6709\u6743\u9650\u67e5\u8be2\u516c\u5171\u5b57\u6bb5'" + MetaUtils.getBusinessName(entityClass) + "." + key + "'!");
                }
                FieldValidation validation = COMMON_FIELD_VALID.get(key);
                targetSetterName = validation.getSetterName();
            } else {
                targetSetterName = TypeCaster.getStterName(key);
            }
            Method targetMethod = TypeCaster.getSetterFromCache(entityClass, targetSetterName);
            if (targetMethod == null) {
                throw new RuntimeException("[DATAHUB] \u5b9e\u4f53\u7c7b'" + entityClass.getSimpleName() + "'\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5'" + key + "'!");
            }
            Class<?> targetType = targetMethod.getParameterTypes()[0];
            if (criteriaNode.getOp() == CriteriaOperatorEnum.IN) {
                if (value == null || !(value instanceof Iterable)) {
                    throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a\u5bf9\u4e8e\u8868\u8fbe\u5f0f '" + String.valueOf(value) + "' \u4e0d\u80fd\u7528\u64cd\u4f5c\u7b26 'in'!");
                }
                ArrayList list = new ArrayList();
                for (Object itemValue : (Iterable)value) {
                    itemValue = TypeCaster.castValue(criteriaNode, entityClass, targetType, itemValue);
                    list.add(itemValue);
                }
                criteriaNode.setValue(list);
            } else {
                value = TypeCaster.castValue(criteriaNode, entityClass, targetType, value);
                criteriaNode.setValue(value);
            }
        }
        if (criteriaNode.getChildren() != null) {
            for (CriteriaNode child : criteriaNode.getChildren()) {
                TypeCaster.cast(child, entityClass);
            }
        }
    }

    private static boolean isCommonField(String fieldName) {
        return fieldName.startsWith("$");
    }

    private static boolean hasRightToUseCommonField(String fieldName) {
        FieldValidation validation = COMMON_FIELD_VALID.get(fieldName);
        if (validation == null) {
            return true;
        }
        return validation.isValid();
    }

    private static String valueString(Object value) {
        if (value instanceof CharSequence) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }

    static {
        COMMON_FIELD_VALID.put("$rowKey", new FieldValidation(true, "rowKey"));
        COMMON_FIELD_VALID.put("$appId", new FieldValidation(false, "appId"));
        COMMON_FIELD_VALID.put("$creator", new FieldValidation(true, "creator"));
        COMMON_FIELD_VALID.put("$createTime", new FieldValidation(true, "serverSideCreateTime"));
        COMMON_FIELD_VALID.put("$updateTime", new FieldValidation(true, "serverSideUpdateTime"));
        SETTER_CACHE = new ConcurrentHashMap<Class, Map<String, Method>>();
    }

    static class FieldValidation {
        private final boolean valid;
        private final String propName;

        public FieldValidation(boolean valid, String propName) {
            this.valid = valid;
            this.propName = propName;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getPropName() {
            return this.propName;
        }

        public String getSetterName() {
            return TypeCaster.getStterName(this.propName);
        }
    }
}

