/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.annotation.RowKey;
import com.thebeastshop.datahub.client.exception.DatahubAnnotationException;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DatahubProperty {
    private static final Class[] SUPPORTED_ANNOCATIONS = new Class[]{RowKey.class, AppId.class, Creator.class, Reviser.class, DataCreateTime.class, DataUpdateTime.class};
    private static final Set<Class> SUPPORTED_ANNOTATIONS_SET = new HashSet<Class>();
    private final Class entityClass;
    private final PropertyDescriptor propDes;
    private final String name;
    private final Annotation annotation;
    private final Class annotationType;
    private final boolean isCommon;

    public DatahubProperty(Class entityClass, PropertyDescriptor propDes) {
        this.entityClass = entityClass;
        this.propDes = propDes;
        this.name = propDes.getName();
        this.annotation = this.getDesignatedAnnotation(this.getAnnotations());
        this.annotationType = MetaUtils.getAnnotationClass(this.annotation);
        this.isCommon = this.annotation != null;
    }

    private void filterAnnotations(List<Annotation> rets, Set<Class> annClasses, Annotation[] anns) {
        for (Annotation ann : anns) {
            Class annCls;
            if (!DatahubProperty.isSupportAnnotation(ann) || annClasses.contains(annCls = MetaUtils.getAnnotationClass(ann))) continue;
            rets.add(ann);
            annClasses.add(annCls);
        }
    }

    private List<Annotation> getAnnotations() {
        LinkedList<Annotation> rets = new LinkedList<Annotation>();
        Field[] fields = this.entityClass.getDeclaredFields();
        HashSet<Class> annClasses = new HashSet<Class>();
        for (Field field : fields) {
            if (!field.getName().equals(this.name)) continue;
            this.filterAnnotations(rets, annClasses, field.getDeclaredAnnotations());
        }
        Annotation[] rmtdAnns = this.propDes.getReadMethod().getAnnotations();
        this.filterAnnotations(rets, annClasses, rmtdAnns);
        Annotation[] wmtdAnns = this.propDes.getWriteMethod().getAnnotations();
        this.filterAnnotations(rets, annClasses, wmtdAnns);
        return rets;
    }

    private Annotation getDesignatedAnnotation(List<Annotation> annotations) {
        Annotation retAnn = null;
        for (Annotation ann : annotations) {
            if (!DatahubProperty.isSupportAnnotation(ann)) continue;
            this.assertAnnotation(ann);
            retAnn = ann;
        }
        return retAnn;
    }

    public String getName() {
        return this.name;
    }

    public PropertyDescriptor getPropDes() {
        return this.propDes;
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Class getAnnotationType() {
        return this.annotationType;
    }

    public static boolean isSupportAnnotation(Annotation ann) {
        Class annClass = MetaUtils.getAnnotationClass(ann);
        return DatahubProperty.isSupportAnnotation(annClass);
    }

    public static boolean isSupportAnnotation(Class annClass) {
        return SUPPORTED_ANNOTATIONS_SET.contains(annClass);
    }

    private void assertAnnotation(Annotation ann) {
        if (this.annotation != null && this.annotation.getClass() != ann.getClass()) {
            throw new DatahubAnnotationException(this.entityClass, this.propDes.getName(), this.annotation.getClass(), ann.getClass());
        }
    }

    public Class getPropertyType() {
        return this.propDes.getPropertyType();
    }

    public DataTypeEnum getDataType() {
        Class type = this.getPropertyType();
        DataTypeEnum dataType = DataTypeEnum.getEnumByType((Class)type);
        return dataType;
    }

    public Object getValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        Method readMethod = this.propDes.getReadMethod();
        return readMethod.invoke(bean, new Object[0]);
    }

    public void setValue(Object bean, Object value) throws InvocationTargetException, IllegalAccessException {
        Method writeMethod = this.propDes.getWriteMethod();
        writeMethod.invoke(bean, value);
    }

    static {
        for (Class cls : SUPPORTED_ANNOCATIONS) {
            SUPPORTED_ANNOTATIONS_SET.add(cls);
        }
    }
}

