/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatahubBeanUtil {
    private static final Map<Class, DatahubMetaClass> metaClassesCache = new ConcurrentHashMap<Class, DatahubMetaClass>();

    private DatahubBeanUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatahubMetaClass getMetaClass(Class entityClass) {
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClassFromCache(entityClass);
        if (metaClass != null) return metaClass;
        Class<DatahubBeanUtil> clazz = DatahubBeanUtil.class;
        synchronized (DatahubBeanUtil.class) {
            metaClass = metaClassesCache.get(entityClass);
            if (metaClass != null) return metaClass;
            String name = MetaUtils.getBusinessName(entityClass);
            metaClass = new DatahubMetaClass(entityClass, name);
            metaClassesCache.put(entityClass, metaClass);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return metaClass;
        }
    }

    static DatahubMetaClass getMetaClassFromCache(Class entityClass) {
        return metaClassesCache.get(entityClass);
    }

    public static Long getRowKey(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getRowkeyValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getAppId(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getAppIdValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCreator(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getCreatorValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getReviser(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getReviserValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date getCreateTime(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getCreateTimeValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date getUpdateTime(Object bean) {
        try {
            return DatahubBeanUtil.getMetaClass(bean.getClass()).getUpdateTimeValue(bean);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

