/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.thebeastshop.datahub.api.Result;
import com.thebeastshop.datahub.client.DatahubClient;
import com.thebeastshop.datahub.dto.BizCondition;
import com.thebeastshop.datahub.enums.DataTypeEnum;
import com.thebeastshop.datahub.enums.ResultCodeEnum;
import com.thebeastshop.datahub.vo.BusinessProperty;
import com.thebeastshop.datahub.vo.BusinessRecord;
import com.thebeastshop.datahub.vo.BusinessStruct;
import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.kit.prop.PropConstants;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class KafkaDatahubClient
implements DatahubClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_TIMEOUT = 5;
    private String appId;
    private String address;
    private int timeout;
    private String uri;
    @Autowired
    private KafkaProducerClient kafkaProducerClient;
    private final PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager();
    private RequestConfig requestConfig;

    public KafkaDatahubClient() {
    }

    public KafkaDatahubClient(String address) {
        this(null, address);
    }

    public KafkaDatahubClient(String appId, String address) {
        this(appId, address, null);
    }

    public KafkaDatahubClient(String appId, String address, KafkaProducerClient kafkaProducerClient) {
        this(appId, address, kafkaProducerClient, 5);
    }

    public KafkaDatahubClient(String appId, String address, KafkaProducerClient kafkaProducerClient, int timeout) {
        this.kafkaProducerClient = kafkaProducerClient;
        this.appId = StringUtils.isNotBlank((CharSequence)appId) ? appId : PropConstants.getAppId();
        this.address = address;
        this.timeout = timeout;
        this.init();
    }

    private void init() {
        if (!this.address.startsWith("http")) {
            this.uri = "http://";
        }
        this.uri = this.uri + this.address + "/datahub/" + this.appId;
        this.poolingConnManager.setMaxTotal(50);
        this.poolingConnManager.setDefaultMaxPerRoute(50);
        this.requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).setConnectionRequestTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000).build();
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    private HttpClient buildHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingConnManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private <T> BusinessStruct convertT2Struct(T t) {
        BusinessStruct struct = new BusinessStruct(t.getClass().getSimpleName());
        Field[] fields = t.getClass().getDeclaredFields();
        ArrayList properties = Lists.newArrayListWithCapacity((int)fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                properties.add(new BusinessProperty(DataTypeEnum.getEnumByType(field.getType()), field.getName(), field.get(t)));
            }
            catch (IllegalAccessException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: fieldName: {}", (Object)field.getName(), (Object)e);
            }
        }
        struct.setProperties((List)properties);
        return struct;
    }

    private <T> T convertStruct2T(BusinessStruct struct, Class<T> tClass) {
        T t = null;
        try {
            t = tClass.newInstance();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (BusinessProperty property : struct.getProperties()) {
                if (property.getValue() == null) continue;
                map.put(property.getName(), property.getDataType().castValue(property.getValue()));
            }
            for (Field field : tClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (!map.containsKey(field.getName())) continue;
                try {
                    DataTypeEnum dataType = DataTypeEnum.getEnumByType(field.getType());
                    switch (dataType) {
                        case LIST: {
                            Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                            field.set(t, JSON.parseArray((String)map.get(field.getName()).toString(), (Type[])types));
                            break;
                        }
                        case MAP: {
                            field.set(t, JSON.parseObject((String)map.get(field.getName()).toString(), (Type)field.getGenericType(), (Feature[])new Feature[0]));
                            break;
                        }
                        case OBJECT: {
                            field.set(t, JSON.parseObject((String)map.get(field.getName()).toString(), (Type)field.getGenericType(), (Feature[])new Feature[0]));
                            break;
                        }
                        default: {
                            field.set(t, map.get(field.getName()));
                            break;
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.error("\u8bbe\u7f6e\u6cdb\u578b\u5b9e\u4f8b\u5c5e\u6027\u503c\u51fa\u9519: fieldName: {}", (Object)field.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4e1a\u52a1\u7ed3\u6784\u8f6c\u6362\u6cdb\u578b\u5b9e\u4f8b\u51fa\u9519:", (Throwable)e);
        }
        return t;
    }

    @Override
    public <T> void create(T record) {
        this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchCreate(List<T> records) {
        for (T record : records) {
            BusinessRecord br = new BusinessRecord();
            br.setAppId(this.appId);
            br.setBusiness(this.convertT2Struct(record));
            this.kafkaProducerClient.send("datahub_biz_record", "create", (Object)br);
        }
    }

    @Override
    public <T> void update(T record) {
        this.batchUpdate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchUpdate(List<T> records) {
        for (T record : records) {
            BusinessRecord br = new BusinessRecord();
            br.setAppId(this.appId);
            br.setBusiness(this.convertT2Struct(record));
            this.kafkaProducerClient.send("datahub_biz_record", "update", (Object)br);
        }
    }

    @Override
    public <T> T getById(Long id, Class<T> tClass) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpGet httpGet = new HttpGet(this.uri + "/" + tClass.getSimpleName() + "/" + id);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<BusinessRecord>>(){}, (Feature[])new Feature[0]);
                if (result.getCode().equals(ResultCodeEnum.OK.code)) {
                    T t = null;
                    if (result.getData() != null) {
                        t = this.convertStruct2T(((BusinessRecord)result.getData()).getBusiness(), tClass);
                    }
                    return t;
                }
                this.log.error("\u6839\u636eID\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)result.getCode(), (Object)result.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error("\u6839\u636eID\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    @Override
    public <T> List<T> getByCond(List<BizCondition> conditions, Class<T> tClass) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpPost httpPost = new HttpPost(this.uri + "/" + tClass.getSimpleName() + "/search");
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(conditions), ContentType.APPLICATION_JSON));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<List<BusinessRecord>>>(){}, (Feature[])new Feature[0]);
                if (result.getCode().equals(ResultCodeEnum.OK.code)) {
                    ArrayList tList = null;
                    List businessRecords = (List)result.getData();
                    if (CollectionUtils.isNotEmpty((Collection)businessRecords)) {
                        tList = Lists.newArrayListWithCapacity((int)businessRecords.size());
                        for (BusinessRecord businessRecord : businessRecords) {
                            tList.add(this.convertStruct2T(businessRecord.getBusiness(), tClass));
                        }
                    }
                    return tList;
                }
                this.log.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)result.getCode(), (Object)result.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return null;
    }
}

