/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.coupon.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVUtil {
    private static final Logger log = LoggerFactory.getLogger(CSVUtil.class);
    public static final char ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final String DEFAULT_LINE_END = "\n";
    private static final String DEFAULT_ENCODING = "GB18030";

    public static byte[] write(List<List<String>> allLines) {
        PrintWriter pw;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        for (List<String> nextLine : allLines) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nextLine.size(); ++i) {
                String nextElement;
                if (i != 0) {
                    sb.append(',');
                }
                if ((nextElement = nextLine.get(i)) == null) continue;
                sb.append('\"');
                for (int j = 0; j < nextElement.length(); ++j) {
                    char nextChar = nextElement.charAt(j);
                    if (nextChar == '\"') {
                        sb.append('\"').append(nextChar);
                        continue;
                    }
                    sb.append(nextChar);
                }
                sb.append('\"');
            }
            sb.append(DEFAULT_LINE_END);
            pw.write(sb.toString());
        }
        pw.flush();
        pw.close();
        try {
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write CSV File Error");
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<String>> read(InputStream is) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        BufferedReader br = null;
        try {
            String nextLine;
            br = new BufferedReader(new InputStreamReader(is, DEFAULT_ENCODING));
            while ((nextLine = br.readLine()) != null) {
                ArrayList<String> line = new ArrayList<String>();
                for (String element : nextLine.split(",")) {
                    if (element.startsWith("\"")) {
                        if (element.length() <= 2 || !element.startsWith("\"") || !element.endsWith("\"")) continue;
                        element = element.substring(1, element.length() - 1).replaceAll("68", "\"");
                        line.add(element);
                        continue;
                    }
                    line.add(element);
                }
                allLines.add(line);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("", (Throwable)e);
            List<List<String>> list = null;
            return list;
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            List<List<String>> list = null;
            return list;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                log.warn("", (Throwable)e);
                return null;
            }
        }
        return allLines;
    }
}

